<?php

namespace App\Http\Controllers\Admin;

use App\Models\Category;
use App\Http\Requests\Admin\CategoryRequest;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Image;

class CategoryController extends Controller
{
    public function index( )
    {
        $this->authorize('view_categories', Category::class);
        $data = Category::whereParentId(null)->orderBy('id', 'DESC')->paginate(10);

        return view('admin.categories.index', compact('data'));
    }
    public function show(Category $category) {

        $this->authorize('show_categories', $category);
        return view('admin.categories.show', compact('category'));
    }

    public function create()
    {
        $this->authorize('create_categories', Category::class);


        return view('admin.categories.create');
    }

    public function store(CategoryRequest $request) {

        $this->authorize('create_categories', Category::class);

        if ( isset($request->photo) && $request->photo ){
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $image = UploadImage($request->file('photo'), 'categories', '/uploads/categories');

        }
//        dd($request->all());
        $category = new Category();
        $category['name->ar']=$request->name_ar;
        $category['name->en']=$request->name_en;
        $category['height']=isset($height)?$height:null;
        $category['width']=isset($width)?$width:null;
        $category['image']=isset($image) ? $image : '';
        $category->save();


        return $category ?
            redirect()->route('admin.categories.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.categories.index')->with('warning', trans('messages.addNO'));
    }

    public function edit(Category $category) {

        $this->authorize('edit_categories', $category);

        return view('admin.categories.edit',compact('category'));
    }


    public function update(CategoryRequest $request, Category $category) {

        $this->authorize('edit_categories', $category);


        if ( isset($request->photo) && $request->photo ){
            @unlink(public_path('uploads/categories/') . $category->image);
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $image = UploadImage($request->file('photo'), 'categories', '/uploads/categories');

        }

        $category['name->ar']=$request->name_ar;
        $category['name->en']=$request->name_en;
        $category['height']=isset($height)?$height:null;
        $category['width']=isset($width)?$width:null;
        $category['image']=isset($image) ? $image : $category->image;
        $category->save();

        return $category ?
            redirect()->route('admin.categories.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.categories.index')->with('warning', trans('messages.updateNO'));
    }



    public function destroy(Request $request) {

        $data = Category::find($request->id);

        //check-if-this-currency-signed to products


        if( $data->products()->count() > 0)
            return json_encode(['code' => '2', 'message' => trans('messages.cant_delete')]);


        @unlink(public_path('uploads/categories/') . $data->image);

        $url = route('admin.categories.index');
        $deleted = $data->delete();


        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }

    public function changeSpecial(Request $request ) {


        if ($request->special == "special" && Category::whereSpecial("special")->count() == 7){
            return  json_encode(['code'=> '2', 'message'=> "عليك ازالة قسم من التمييز لاضافة هذا القسم"]);
        }
        $updated = Category::where('id', $request->id)->update(['special' => $request->special]);
        $url = route('admin.categories.index');

        return $updated
            ? json_encode(['code'=> '1', 'url'=> $url])
            : json_encode(['code'=> '0', 'message'=> 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
    public function remove_add(Request $request ) {

        if ($request->special == "remove"){
            $updated = Category::where('id', $request->id)->first();
            @unlink(public_path('uploads/ads/') . $updated->ad_image);
            @unlink(public_path('uploads/ads/') . $updated->ad_image_en);
            $updated->update(['add_ads' => $request->special , 'ad_name' => null
                ,'ad_description' => null , 'ad_image' => null, 'ad_image_en' => null , 'ad_product_id' => null]);
        }

        $url = route('admin.categories.index');

        return $updated
            ? json_encode(['code'=> '1', 'url'=> $url])
            : json_encode(['code'=> '0', 'message'=> 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
}
