<?php

namespace App\Http\Controllers\Admin;

use App\Models\Category;


use App\Http\Requests\Admin\SliderRequest;
use App\Models\Product;
use App\Models\Slider;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Image;

class SliderController extends Controller
{
    public function index()
    {
        $this->authorize('view_sliders', Slider::class);
        $data = Slider::orderBy('id', 'DESC')->paginate(10);

        return view('admin.sliders.index', compact('data'));
    }


    public function create()
    {
        $this->authorize('create_sliders', Slider::class);


        return view('admin.sliders.create');
    }

    public function store(SliderRequest $request) {

        $this->authorize('create_sliders', Slider::class);

        if ( isset($request->photo) && $request->photo ){
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $request['height']=$height;
            $request['width']=$width;
            $request['image'] = UploadImage($request->file('photo'), 'sliders', '/uploads/sliders');

        }
        if ( isset($request->photo_en) && $request->photo_en ){
            $upload_file = $request->file('photo_en');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $request['height_en']=$height;
            $request['width_en']=$width;
            $request['image_en'] = UploadImage($request->file('photo_en'), 'sliders', '/uploads/sliders');

        }
        $request['category_id']= $request->sub_category_id  ?  $request->sub_category_id :  $request->category_id;
        $data = Slider::create($request->all());

        return $data ?
            redirect()->route('admin.sliders.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.sliders.index')->with('warning', trans('messages.addNO'));
    }

    public function edit(Slider $slider) {

        $this->authorize('edit_sliders', $slider);
        $parent_id = $slider->link_type == "category" ? Category::find($slider->category_id)->parent_id :'';

        $categories = Category::whereParentId(null)->get();
        $products = Product::whereType('product')->get();

        return view('admin.sliders.edit', compact('slider','categories','products','parent_id'));
    }

    public function update(SliderRequest $request, Slider $slider) {

        $this->authorize('edit_sliders', $slider);

        if ( isset($request->photo) && $request->photo ){
            @unlink(public_path('uploads/sliders/') . $slider->image);
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $request['height']=$height;
            $request['width']=$width;
            $request['image'] = UploadImage($request->file('photo'), 'sliders', '/uploads/sliders');

        }
        if ( isset($request->photo_en) && $request->photo_en ){
            @unlink(public_path('uploads/sliders/') . $slider->image_en);
            $upload_file1 = $request->file('photo_en');
            $height = Image::make($upload_file1)->height();
            $width = Image::make($upload_file1)->width();
            $request['height_en']=$height;
            $request['width_en']=$width;

            $request['image_en'] = UploadImage($request->file('photo_en'), 'sliders', '/uploads/sliders');

        }
        $request['category_id']= $request->sub_category_id  ?  $request->sub_category_id :  $request->category_id;
        $data = $slider->update($request->all());


        return $data ?
            redirect()->route('admin.sliders.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.sliders.index')->with('warning', trans('messages.updateNO'));
    }

    public function destroy(Request $request) {

        $data = Slider::find($request->id);

        @unlink(public_path('uploads/sliders/') . $data->image);
        $deleted = $data->delete();
        $url = route('admin.sliders.index');

        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
}
