<?php

namespace App\Http\Controllers\Api\Dealer;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Dealer\PullBalanceRequest;
use App\Http\Resources\Dealer\WalletResource;
use App\Models\Order;
use App\Models\OrderProduct;
use App\Models\UserWallet;
use Facade\FlareClient\Api;
use Illuminate\Http\Request;

class WalletController extends Controller
{
    //
    public function wallet(){
        $sales_number = OrderProduct::whereHas('products',function ($q){
            $q->where('user_id',\request()->user()->id);
        })->whereHas('order',function ($q2){
            $q2->where('status','done');
        })->count();
        $total = Order::where('status','done')->whereHas('products',function ($q){
            $q->whereHas('products',function ($q2){
                $q2->where('user_id',\request()->user()->id);
            });
        })->sum('all_total');
        $sales_price = $total - ($total * \request()->user()->app_percentage /100);
        $pulls =UserWallet::whereUserId(\request()->user()->id)->orderBy('id','desc')->paginate(10);
        WalletResource::collection($pulls);
        $data=[
            'wallet'=>\request()->user()->wallet,
            'sales_number'=>$sales_number,
            'sales_price'=>$sales_price,
            'app_price'=>$total * \request()->user()->app_percentage /100,
            'data' => $pulls

        ];
        return ApiController::respondWithSuccess($data);
    }
    public function pull_request(PullBalanceRequest $request){

        if ($request->balance < settings()->minimum_pull ){
            return ApiController::respondWithError(trans('messages.minimum_pull_for_wallet').' '.settings()->minimum_pull.' '.trans('messages.sar'));
        }
        if (UserWallet::whereUserId($request->user()->id)->whereStatus('waiting')->count() > 0){
            return ApiController::respondWithError(trans('messages.you_cant_pull'));
        }
        if ($request->balance > $request->user()->wallet){
            return ApiController::respondWithError(trans('messages.you_cant_pull_this_amount'));
        }
        $request['user_id']=$request->user()->id;
        UserWallet::create($request->all());
        return response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200);

    }
}
