<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\AddCommnentRequest;
use App\Http\Requests\Api\AddPostRequest;
use App\Http\Requests\Api\EditPostRequest;
use App\Http\Resources\User\CommentsResource;
use App\Http\Resources\User\PostResource;
use App\Models\Comment;
use App\Models\Post;
use Facade\FlareClient\Api;
use Illuminate\Http\Request;
use Image;

class PostController extends Controller
{
    //
    public function add_post(AddPostRequest $request){

        if ($request->photo){
            $upload_file = $request->photo;
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $image =  UploadImage($request->photo, 'posts', '/uploads/posts');
        }
       $posts = Post::create([
            'user_id'=>$request->user()->id,
            'open_comments'=>$request->open_comments,
            'description'=>$request->description,
            'image'=>isset($image) ? $image : null,
            'height'=>isset($height) ? $height : null,
            'width'=>isset($width) ? $width : null,

        ]);
       $data = new PostResource($posts);
        return ApiController::respondWithSuccess($data);

    }

    public function edit_posts(EditPostRequest $request){

        $post =  $request->user()->posts()->where('id',$request->post_id)->first();

        $post->update([
            'open_comments'=>$request->open_comments,
            'description'=>$request->description,
            'image'=>$request->photo ? UploadImage($request->file('photo'), 'posts', '/uploads/posts') : $post->image,

        ]);
       $data = new PostResource($post);
        return ApiController::respondWithSuccess($data);

    }
    public function get_posts(){

       $posts = \request()->user()->posts()->paginate(10);
         PostResource::collection($posts);
        return ApiController::respondWithSuccess($posts);

    }
    public function post_details($id){

       $posts = Post::find($id);
       if (! $posts){
           return ApiController::respondWithServerError();
       }
       $data = new PostResource($posts);
        return ApiController::respondWithSuccess($data);

    }
    public function all_posts(){

       $posts =Post::paginate(10);
         PostResource::collection($posts);
        return ApiController::respondWithSuccess($posts);

    }

    public function delete_posts($id){

       $posts = Post::find($id);
       if (! $posts){
           return ApiController::respondWithServerError();
       }
       $posts->delete();

       return  $posts
           ? response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200)
           : ApiController::respondWithServerError();

    }

    public function get_comments($id){

        $posts =Post::find($id);
        $comments = Comment::wherePostId($id)->paginate(10);
        CommentsResource::collection($comments);
        return ApiController::respondWithSuccess($comments);

    }
    public function add_comment(AddCommnentRequest $request){

        $request['post_id'] = $request->post_id;
        $request['user_id'] = $request->user()->id;
        if (Post::find($request->post_id)->open_comments == "available"){
            $posts = Comment::create($request->all());
            $data = new CommentsResource($posts);
            return ApiController::respondWithSuccess($data);
        }else{
            return ApiController::respondWithError(trans('messages.cant_add_comment'));
        }

    }
    public function delete_comment($id){

        $comment = Comment::find($id);
        if (! $comment){
            return ApiController::respondWithServerError();
        }
        $comment->delete();

        return  $comment
            ? response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200)
            : ApiController::respondWithServerError();

    }
}
