<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\User\CartRequest;
use App\Http\Requests\Api\User\CheckAddressRequest;
use App\Http\Resources\User\CartDataResource;
use App\Models\Cart;
use App\Models\Product;
use App\Models\Region;
use Facade\FlareClient\Api;
use Illuminate\Http\Request;
use Validator;

class CartController extends Controller
{
    //
    public function add_to_cart(CartRequest $request){
        $carts = $request->user()->carts()->count();
        $products = Product::find($request->product_id);
        //check if added before or not
        if (Cart::where(['user_id' =>$request->user()->id , 'product_id' => $request->product_id])->first()){
            return ApiController::respondWithSuccessMessage(trans('messages.added_before_to_cart'));
        }
        if ($carts > 0){
            $product = Product::find($request->user()->carts()->first()->product_id);

            if ($product !== null &&  $product->user_id !== Product::find($request->product_id)->user_id ){
                return ApiController::respondWithErrorCart(trans('messages.cant_add_product_of_different_dealer'));
            }
            if ($request->user()->carts()->where('region_id',$request->region_id)->where('city_id',$request->city_id)->count() == 0){
                return ApiController::respondWithErrorCart(trans('messages.cant_add_product_of_different_address'));
            }
            $request['user_id']=$request->user()->id;
            $request['productable_type']=$products->type == "product" ? "App\Product" : "App\Gift";
            $request['range']=$products->range;
            $request['price']=$products->after_discount;
            $request['total']=$products->after_discount;
            Cart::create($request->all());

            return ApiController::respondWithSuccessMessage(trans('messages.add_to_cart'));
        }
        $request['user_id']=$request->user()->id;
        $request['productable_type']=$products->type == "product" ? "App\Product" : "App\Gift";
        $request['range']=$products->range;
        $request['price']=$products->after_discount;
        $request['total']=$products->after_discount;
        Cart::create($request->all());

        return ApiController::respondWithSuccessMessage(trans('messages.add_to_cart'));

    }
    public function add_new_different_product_to_cart(CartRequest $request){
        $request->user()->carts()->delete();
        $carts = $request->user()->carts()->count();
        $products = Product::find($request->product_id);
        //check if added before or not
        if (Cart::where(['user_id' =>$request->user()->id , 'product_id' => $request->product_id])->first()){
            return ApiController::respondWithSuccessMessage(trans('messages.added_before_to_cart'));
        }
        if ($carts > 0){
            $product = Product::find($request->user()->carts()->first()->product_id);

            if ($product !== null && $product->user_id !== Product::find($request->product_id)->user_id ){
                return ApiController::respondWithErrorCart(trans('messages.cant_add_product_of_different_dealer'));
            }
            if ($request->user()->carts()->where('region_id',$request->region_id)->where('city_id',$request->city_id)->count() == 0){
                return ApiController::respondWithErrorCart(trans('messages.cant_add_product_of_different_address'));
            }
            $request['user_id']=$request->user()->id;
            $request['productable_type']=$products->type == "product" ? "App\Product" : "App\Gift";
            $request['range']=$products->range;
            $request['price']=$products->after_discount;
            $request['total']=$products->after_discount;
            Cart::create($request->all());

            return ApiController::respondWithSuccessMessage(trans('messages.add_to_cart'));
        }
        $request['user_id']=$request->user()->id;
        $request['productable_type']=$products->type == "product" ? "App\Product" : "App\Gift";
        $request['range']=$products->range;
        $request['price']=$products->after_discount;
        $request['total']=$products->after_discount;
        Cart::create($request->all());

        return ApiController::respondWithSuccessMessage(trans('messages.add_to_cart'));

    }
    public function check_address(CheckAddressRequest $request){
        if (Cart::where(['user_id' =>$request->user()->id])->count() == 0){
            return ApiController::respondWithError( trans('web.empty_cart'));
        }
        $counts = Product::whereIn('id',Cart::where(['user_id' =>$request->user()->id])->whereRange('inside')->get()->pluck('product_id')->toArray())
            ->WhereHas('user',function ($q) use ($request){
            $q->whereHas('regions',function ($q2) use ($request){
                $q2->where('region_id',$request->region_id);
            });
        })->count();
        if (count(Cart::where(['user_id' =>$request->user()->id])->whereRange('inside')->get()->pluck('product_id')->toArray()) > 0){
            if ($counts == 0){
                return ApiController::respondWithErrorCart(trans('messages.cant_continue'));
            }
        }

//        if ($request->user()->carts()->where('region_id',$request->region_id)->where('city_id',$request->city_id)->count() == 0){
//            return ApiController::respondWithErrorCart(trans('messages.cant_continue'));
//        }
        return response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200);


    }
    public function get_carts(Request $request){

        $carts = Cart::whereUserId($request->user()->id)->get();
        if (Cart::whereUserId($request->user()->id)->whereRange('inside')->count() > 0){
            $shipping_cost = Region::find(Cart::whereUserId($request->user()->id)->first()->region_id)->shipping_cost;
        }else{
            $shipping_cost = settings()->outside_price;
        }
        $data = [
            'shipping_cost' => $shipping_cost,
            'all_total' => Cart::whereUserId($request->user()->id)->sum('total') + $shipping_cost,
            'carts' => CartDataResource::collection($carts)
        ];

        return ApiController::respondWithSuccess($data);

    }
    public function remove_from_cart(Request $request){
        $rules = [
            'cart_id'     => 'required|exists:carts,id',
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails())
            return ApiController::respondWithError(validateRules($validator->errors(), $rules));

        $deleted = Cart::find($request->cart_id)->delete();
        $carts = Cart::whereUserId($request->user()->id)->get();
        if (Cart::whereUserId($request->user()->id)->whereRange('inside')->count() > 0){
            $shipping_cost = Region::find(Cart::whereUserId($request->user()->id)->first()->region_id)->shipping_cost;
        }else{
            $shipping_cost = settings()->outside_price;
        }
        $data = [
            'shipping_cost' => $shipping_cost,
            'all_total' => Cart::whereUserId($request->user()->id)->sum('total') + $shipping_cost,
            'carts' => CartDataResource::collection($carts)
        ];

        return $deleted?
            ApiController::respondWithSuccess($data)
            :ApiController::respondWithServerError();

    }
}
