<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Resources\User\HomeProductResource;
use App\Http\Resources\User\SliderResource;
use App\Models\Product;
use App\Models\Slider;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    //
    public function home(Request $request){
        $city_id= $request->header('city-id');
        $region_id= $request->header('region-id');

        $special_products = Product::whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
            ->orWhereHas('user',function ($q)use ($region_id){
                $q->whereHas('regions',function ($q2) use ($region_id){
                    $q2->where('region_id',$region_id);
                });
            })->whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->take(20)->orderBy('id','desc')->get();
        $most_seller_products = Product::whereRange('outside')->where('type','product')->whereStatus(0)->whereActive(1)->where('sold','!=',0)
            ->orWhereHas('user',function ($q)use ($region_id){
                $q->whereHas('regions',function ($q2) use ($region_id){
                    $q2->where('region_id',$region_id);
                });
            })->where('sold','!=',0)->whereStatus(0)->where('type','product')->whereActive(1)->take(10)->orderBy('sold','desc')->get();
        $discount_products = Product::where('discount','!=',null)->where('type','product')->whereStatus(0)->whereActive(1)->whereRange('outside')
            ->orWhereHas('user',function ($q)use ($region_id){
                $q->whereHas('regions',function ($q2) use ($region_id){
                    $q2->where('region_id',$region_id);
                });
            })->where('discount','!=',null)->whereStatus(0)->where('type','product')->whereActive(1)->take(10)->orderBy('id','desc')->get();
        $data = [
            'special_products'=>HomeProductResource::collection($special_products),
            'most_seller_products'=>HomeProductResource::collection($most_seller_products),
            'discount_products'=>HomeProductResource::collection($discount_products),
            'sliders'=>SliderResource::collection(Slider::where('link_type','product')->whereHas('product',function ($q) use ($region_id){
                $q->WhereHas('user',function ($q2)use ($region_id){
                    $q2->whereHas('regions', function ($q3) use ($region_id) {
                        $q3->where('region_id', $region_id);
                    });
                })->orWhere('range','outside');
            })->orWhereIn('link_type',['external_link','category','just_ads'])->inRandomOrder()->get()),

        ];
        return ApiController::respondWithSuccess($data);
    }
    public function search_home(Request $request){
        $city_id= $request->header('city-id');
        $region_id= $request->header('region-id');

        if ($request->name !== null){

            $products = Product::whereRange('outside')->whereStatus(0)->whereActive(1)
                ->where(function ($q) use ($request) {
                    $q->where('title->ar', 'like', $request->name . '%')
                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                })
                ->orWhere(function ($q) use ($request) {
                    $q->where('title->en', 'like', $request->name . '%')
                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                })
                ->orWhereHas('user',function ($q)use ($region_id){
                    $q->whereHas('regions',function ($q2) use ($region_id){
                        $q2->where('region_id',$region_id);
                    });
                })->whereStatus(0)->whereActive(1)->where(function ($q) use ($request) {
                    $q->where('title->ar', 'like', $request->name . '%')
                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                })
                ->orWhere(function ($q) use ($request) {
                    $q->where('title->en', 'like', $request->name . '%')
                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                })

                ->orderBy('id','desc')->paginate(10);
            HomeProductResource::collection($products);
            return ApiController::respondWithSuccess($products);


        }else{
            return response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200);

        }

    }
}
