<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class BankRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        if( $this->method() == 'PATCH' ) {

            return [
                'bank_name'                  => 'required|array',
                "bank_name.*"                => "required|string",
                'name'                  => 'required|array',
                "name.*"                => "required|string",
                "account_number"                => "required",

                'photo'                 => 'nullable|mimes:jpg,gif,jpeg,png,tiff',
            ];
        }
        return [
            'bank_name'                  => 'required|array',
            "bank_name.*"                => "required|string",
            'name'                  => 'required|array',
            "name.*"                => "required|string",
            "account_number"                => "required",
            'photo'                 => 'required|mimes:jpg,gif,jpeg,png,tiff',
        ];
    }
}
