<?php

namespace App\Http\Requests\Api;

use App\Http\Requests\RequestApiParent;

class SendMessageRequest extends RequestApiParent
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'room_id'   => 'required|exists:rooms,id',
            'message'   => 'nullable',
            'file'   => 'nullable',
            'duration'   => 'nullable',
            'file_type'   => 'required|in:file,image,text,voice,gift',
            'senderable_type'   => 'required|in:user,dealer',
        ];
    }
}
