<?php

namespace App\Http\Requests\Api\User;

use App\Http\Requests\RequestApiParent;

class CheckAddressRequest extends RequestApiParent
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'phone' =>['required', 'regex:/^(009665|9665|\+9665|05|5)(5|0|3|6|4|9|1|8|7)([0-9]{7})$/'],
            'name'           => 'required|string',
            'notes'           => 'nullable|string',
            'city_id'     => 'required|exists:regions,id',
            'region_id'     => 'required|exists:regions,id',
        ];
    }
}
