<?php

namespace App\Http\Resources;


use App\Models\Chat;
use App\Models\Employee;
use App\Models\NewsLetter;
use App\Models\Order;
use App\Models\Rate;
use App\Models\Room;
use App\Models\Service;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class RoomResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {


        $last_message = Chat::where('room_id',$this->id)->orderBy('id','desc')->first();
        if ($last_message){
            if ($last_message->type == "file"){
                $message = trans('messages.file');
            }elseif($last_message->type == "image"){
                $message = trans('messages.image');
            }elseif($last_message->type == "voice"){
                $message = trans('messages.voice');
            }elseif($last_message->gift_id !== null){
                $message = trans('messages.offer_to_perform_service');
            }elseif($last_message->type == "text"){
                $message = $last_message->message;
            }

        }

        $data= [
            'id' => $this->id,
            'message' => isset($message) ? $message : '',
            'username'=>$request->user()->id == $this->receiver_id ? User::find($this->sender_id)->name : User::find($this->receiver_id )->name,
            'user_id'=>$request->user()->id == $this->receiver_id ? $this->sender_id : $this->receiver_id,
            'user_type'=>$request->user()->id == $this->receiver_id ? "user" : "dealer",

            'unread_message_count'  => Chat::where('room_id',$this->id)->where('seen',0)->where('sender_id','!=',$request->user()->id)->count(),
            'original_date'=>Chat::where('room_id',$this->id)->orderBy('id','desc')->first()?
                Chat::where('room_id',$this->id)->orderBy('id','desc')->first()->created_at:
                $this->created_at,
            'date'=>Chat::where('room_id',$this->id)->orderBy('id','desc')->first() ?
              (  Carbon::now()->format('y-m-d') == Carbon::parse(Chat::where('room_id',$this->id)->orderBy('id','desc')->first()->created_at)->format('y-m-d') ? Carbon::parse(Chat::where('room_id',$this->id)->orderBy('id','desc')->first()->created_at)->format('h:i A') : Carbon::parse(Chat::where('room_id',$this->id)->orderBy('id','desc')->first()->created_at)->diffForHumans()):
                (Carbon::now()->format('y-m-d') == Carbon::parse($this->created_at)->format('y-m-d') ? Carbon::parse($this->created_at)->format('h:i A') : Carbon::parse($this->created_at)->diffForHumans()),
        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
