<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;
    protected $fillable=[
        'user_id',
        'payment_method',
        'name',
        'phone',
        'notes',
        'shipping_cost',
        'products_total',
        'total_after_coupon',
        'all_total',
        'coupon',
        'region_id',
        'city_id',
        'status',
    ];

    public function region()
    {
        return $this->belongsTo(Region::class,'region_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }
    public function city()
    {
        return $this->belongsTo(Region::class,'city_id');
    }
    public function products()
    {
        return $this->hasMany(OrderProduct::class,'order_id');
    }
}
