<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentMethod extends Model
{
    use HasFactory;
    protected $fillable=[ 'name','type', 'status','icon','method','currency',  'height',
        'width'];
    protected $casts = ['name' => 'json'];
    public function orders()
    {
        return $this->hasMany(Order::class,'payment_method');
    }
}
