<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Permission extends Model
{
    use HasFactory;
    protected $fillable = [
        'name', 'table_name'
    ];

    public static function generatePermissions($table)
    {


        if( $table == 'orders') {
            static::create(['name' => "view_$table", 'table_name' => $table]);
            static::create(['name' => "show_$table", 'table_name' => $table]);
            static::create(['name' => "activate_$table", 'table_name' => $table]);
            static::create(['name' => "cancel_$table", 'table_name' => $table]);
            return;
        }
        if (  $table == 'permissions' ) {
            static::create(['name' => "edit_$table", 'table_name' => $table]);
            return;
        }
        if (  $table == 'order_transfers' ) {
            static::create(['name' => "activate_$table", 'table_name' => $table]);
            return;
        }
        if (  $table == 'employees' ) {
            static::create(['name' => "refuse_$table", 'table_name' => $table]);
            static::create(['name' => "accept_$table", 'table_name' => $table]);
            static::create(['name' => "unaccepted_$table", 'table_name' => $table]);
            return;
        }
        if (  $table == 'sub_categories' ) {
            static::create(['name' => "viewSub_$table", 'table_name' => $table]);
            static::create(['name' => "showSub_$table", 'table_name' => $table]);
            static::create(['name' => "createSub_$table", 'table_name' => $table]);
            static::create(['name' => "editSub_$table", 'table_name' => $table]);
            static::create(['name' => "deleteSub_$table", 'table_name' => $table]);
            static::create(['name' => "activateSub_$table", 'table_name' => $table]);

            return;
        }


        static::create(['name' => "view_$table", 'table_name' => $table]);
        static::create(['name' => "show_$table", 'table_name' => $table]);
        static::create(['name' => "create_$table", 'table_name' => $table]);
        static::create(['name' => "edit_$table", 'table_name' => $table]);
        static::create(['name' => "delete_$table", 'table_name' => $table]);
        static::create(['name' => "activate_$table", 'table_name' => $table]);

        if( $table == 'contacts') {
            static::create(['name' => "reply_$table", 'table_name' => $table]);
        }
    }

    public function roles() {

        return $this->belongsToMany(Role::class)->withTimestamps();
    }

    public function admins() {

        return $this->belongsToMany(Admin::class)->withTimestamps();
    }
}
