<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Post extends Model
{
    use HasFactory;
    protected $fillable=[
        'image',
        'user_id',
        'description',
        'open_comments',
        'height',
        'width'
    ];
    public function user() {

        return $this->belongsTo(User::class);
    }
    public function comments() {

        return $this->hasMany(Comment::class,'post_id');
    }

}
