<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
    use HasFactory;
    protected $fillable=[
        'sender_id',
        'receiver_id',
        'seen',
        'sender_online',
        'receiver_online',

    ];
    protected $appends =['count_unread_message'];

    public function user()
    {
        return $this->belongsTo(User::class,'sender_id');
    }
    public function chats()
    {
        return $this->hasMany(Chat::class);
    }
    public function getCountUnreadMessageAttribute(){
//        $sum= Chat::orderBy('id','desc')->where('sender_id','!=',$this->receiver_id)->where('room_id', $this->id )->where('seen',0)->count();
//
//        if ($sum == 0){
//            $rate = 0;
//            return $rate;
//        }else{
//            $rate = $sum ;
//            return $rate;
//        }
        $date= Chat::orderBy('id','desc')->where('room_id', $this->id )->first();

        return $date->created_at;

    }
}
