<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Permission;
use App\Models\Admin;
use App\Models\Role;
use App\Models\Setting;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('updated_by')->unsigned();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();

            $table->text('about')->nullable();
            $table->text('terms')->nullable();
            $table->double('outside_price')->nullable();

            $table->string('sms_url')->nullable();
            $table->string('sms_username')->nullable();
            $table->string('sms_password')->nullable();
            $table->string('sms_sender')->nullable();


            $table->foreign('updated_by')
                ->references('id')->on('admins')
                ->onDelete('cascade');
            $table->timestamps();
        });

        /////////////////***************************************//////////////////
        Setting::create([
            'updated_by'        => 1,
            'email'             => 'Nosq@email.com',
            'outside_price'             => 20,
            'phone'             => '01027299053',
            'terms'             => ['ar'=>'الشروط و الاحكام', 'en'=>'terms and conditions'],
            'about'             => ['ar'=>'من نحن', 'en'=>'about'],
        ]);
        //****************************************************//
        //**************** CREATE-PERMISSIONS ****************//
        //****************************************************//

        //generate-permissions-for-this-table..
        Permission::generatePermissions('settings');

        //add-these-permissions-to-admin-role(first_one)..
        $adminRole = Role::where('id', 1)->first();
        $adminRole->permissions()->sync( Permission::all()->pluck('id') );

        //add-these-permissions-to-admin-user..
        Admin::where('id', 1)->first()->permissions()->sync( Permission::all()->pluck('id') );
        //****************************************************//
        //***************** END-PERMISSIONS ******************//
        //****************************************************//
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
