<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Permission;
use App\Models\Admin;
use App\Models\Role;

class CreateBanksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('banks', function (Blueprint $table) {
            $table->id();
            $table->text('bank_name');
            $table->text('name');
            $table->text('image');
            $table->string('account_number');
            $table->timestamps();
        });
        //****************************************************//
        //**************** CREATE-PERMISSIONS ****************//
        //****************************************************//

        //generate-permissions-for-this-table..
        Permission::generatePermissions('banks');

        //add-these-permissions-to-admin-role(first_one)..
        $adminRole = Role::where('id', 1)->first();
        $adminRole->permissions()->sync( Permission::all()->pluck('id') );

        //add-these-permissions-to-admin-user..
        Admin::where('id', 1)->first()->permissions()->sync( Permission::all()->pluck('id') );
        //****************************************************//
        //***************** END-PERMISSIONS ******************//
        //****************************************************//
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('banks');
    }
}
