<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Permission;
use App\Models\Role;
use App\Models\Admin;

class CreateOrderTransfersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_transfers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('order_id')->unsigned()->nullable();
            $table->bigInteger('bank_id')->unsigned()->nullable();
            $table->string('bank_name');
            $table->string('user_name')->nullable();
            $table->string('image')->nullable();
            $table->string('account_number');
            $table->double('balance');
            $table->enum('status',['waiting','approved','refuse'])->default('waiting');



            $table->foreign('bank_id')
                ->references('id')->on('banks')
                ->onDelete('cascade');
            $table->foreign('order_id')
                ->references('id')->on('orders')
                ->onDelete('cascade');
            $table->timestamps();
        });
        //****************************************************//
        //**************** CREATE-PERMISSIONS ****************//
        //****************************************************//

        //generate-permissions-for-this-table..
        Permission::generatePermissions('order_transfers');

        //add-these-permissions-to-admin-role(first_one)..
        $adminRole = Role::where('id', 1)->first();
        $adminRole->permissions()->sync( Permission::all()->pluck('id') );

        //add-these-permissions-to-admin-user..
        Admin::where('id', 1)->first()->permissions()->sync( Permission::all()->pluck('id') );
        //****************************************************//
        //***************** END-PERMISSIONS ******************//
        //****************************************************//
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_transfers');
    }
}
