@extends('admin.auth.master')

@section('title')
    @lang('messages.Administration_login')
@endsection

@section('content')

    <h5 class="auth-title">@lang('messages.Administration_login')</h5>
    <form class="login-form form-horizontal form-row-seperated parsley-examples" action="{{ route('admin.post.login') }}"  method="post">

        @csrf
        @include('admin.layouts.alerts')
        <div class="form-group mb-3">
            <label for="emailaddress">@lang('messages.email')</label>
            <input class="form-control" type="email" id="emailaddress" parsley-trigger="change" required placeholder="@lang('messages.email')" name="email" value="{{ old('email') }}">
        </div>

        <div class="form-group mb-3">
            <label for="password">@lang('messages.password')</label>
            <input class="form-control" type="password" parsley-trigger="change" required id="password" placeholder="@lang('messages.password')" name="password">
        </div>
        <div class="form-group mb-3">
            <div class="custom-control custom-checkbox checkbox-info">
                <input type="checkbox" class="custom-control-input" id="checkbox-signin" name="remember" {{ old('remember') ? 'checked' : '' }}>
                <label class="custom-control-label" for="checkbox-signin">@lang('messages.remember')</label>
            </div>
        </div>


        <div class="form-group mb-0 text-center">
            <button class="btn btn-danger btn-block custom-btn" type="submit"> @lang('messages.login') </button>
        </div>

    </form>

@endsection
@section('scripts')
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
@endsection