@extends('admin.layouts.master')

@section('title')
    اضافة اقسام رئيسية
@endsection

@section('styles')
    <link rel="stylesheet" href="{{ URL::asset('admin/css/bootstrap-fileinput.css') }}">
    <link href="{{ URL::asset('admin/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />
@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.categories.index') }}">الاقسام الرئيسية</a></li>
                        <li class="breadcrumb-item active">اضافة اقسام رئيسية</li>
                    </ol>
                </div>
                <h4 class="page-title">اضافة اقسام رئيسية</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-9">
            {!! Form::open([ 'url' => route('admin.categories.store'), 'class' => 'form-horizontal form-row-seperated parsley-examples', 'files'=> 'true']) !!}
            <div class="card-box">
                <h4 class="header-title mb-4">معلومات الاقسام الرئيسية</h4>
                <div class="actions btn-set btn-position" >
                    <button class="btn btn-success" type="submit"  >
                         @lang('messages.save')
                    </button>
                </div>

                <ul class="nav nav-tabs nav-bordered">
                    <li class="nav-item">
                        <a href="#general" data-toggle="tab" aria-expanded="false" class="nav-link active">
                            @lang('messages.general')
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#another" data-toggle="tab" aria-expanded="true" class="nav-link">
                            @lang('messages.another')
                        </a>
                    </li>
                </ul>

                <div class="card-box">
                    <div class="tab-content">
                        @include('admin.categories._form')


                    </div>
                </div>
            </div> <!-- end card-box-->
            {!! Form::close() !!}
        </div> <!-- end col -->


    </div>
    <!-- end row -->


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/js/bootstrap-fileinput.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.js') }}"></script>
    <script type="text/javascript" src="//code.jquery.com/ui/1.12.1/jquery-ui.js" ></script>

    <script type="text/javascript" src="//cdn.datatables.net/v/dt/dt-1.10.12/datatables.min.js"></script>
    <script>
        $(function () {
            $("#table").DataTable();

            $( "#tablecontents" ).sortable({
                items: "tr",
                cursor: 'move',
                opacity: 0.6,
                update: function() {
                    sendOrderToServer();
                }
            });

            function sendOrderToServer() {

                var order = [];
                $('tr.row1').each(function(index,element) {
                    order.push({
                        id: $(this).attr('data-id'),
                        position: index+1
                    });
                });

                {{--$.ajax({--}}
                {{--    type: "POST",--}}
                {{--    dataType: "json",--}}
                {{--    url: "{{ url('demos/sortabledatatable') }}",--}}
                {{--    data: {--}}
                {{--        order:order,--}}
                {{--        _token: '{{csrf_token()}}'--}}
                {{--    },--}}
                {{--    success: function(response) {--}}
                {{--        if (response.status == "success") {--}}
                {{--            console.log(response);--}}
                {{--        } else {--}}
                {{--            console.log(response);--}}
                {{--        }--}}
                {{--    }--}}
                {{--});--}}

            }
        });




    </script>
@endsection
