@extends('admin.layouts.master')

@section('title')
    الدول
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/select.bootstrap4.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />

@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.countries.index') }}">الدول</a></li>
                        <li class="breadcrumb-item active">الدول</li>
                    </ol>
                </div>
                <h4 class="page-title">عرض جميع الدول</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-4">الدول</h4>

                    <table id="datatable-buttons-custom" class="table table-striped dt-responsive nowrap">
                        <thead>
                        <tr>
                            <th> # </th>
                            <th> @lang('messages.name') </th>
                            <th> كود الدولة</th>
                            <th> حالة الدولة</th>
                            <th> الدولة الافتراضية</th>
                            <th> علم الدولة</th>
                            <th> @lang('messages.operations') </th>
                        </tr>
                        </thead>

                        <tbody>
                        @if($data->count())
                            <?php $i = 0; ?>
                            @foreach( $data as $value )
                                <?php ++$i; ?>
                                <tr>

                                    <td> {{ $i }} </td>

                                    <td class="no_dec">
                                        {{ $value->name[App::getLocale()]  }}
                                    </td>
                                    <td class="no_dec">
                                    <span style="background-color: {{ $value->color  }};"> +{{ $value->country_code  }}</span>
                                    </td>
                                    <td>

                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" class="custom-control-input" value="{{$value->status ? 0 : 1}}"   @if($value->status == 1) checked @endif onclick="enableUser({{$value->id}})" id="customSwitch1{{$value->id}}">
                                            <label class="custom-control-label" for="customSwitch1{{$value->id}}">مفعل/معطل</label>
                                        </div>

                                    </td>
                                    <td>

                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" class="custom-control-input" value="{{$value->default ? 0 : 1}}"   @if($value->default == 1) checked @endif onclick="enableDefault({{$value->id}})" id="customSwitchDefault{{$value->id}}">
                                            <label class="custom-control-label" for="customSwitchDefault{{$value->id}}">مفعل/معطل</label>
                                        </div>

                                    </td>

                                   <td>
                                       <img class="rounded mr-1" height="60"  src="{{ URL::asset('uploads/countries/'.$value->flag) }}">
                                   </td>

                                    <td>
                                            <div class="btn-group mb-2">
                                                <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-chevron-down options-custom"></i>@lang('messages.operations') </button>
                                                <div class="dropdown-menu">


                                                    @can('edit_countries', $value)

                                                        <a class="dropdown-item" href="{{ route('admin.countries.edit', $value->id) }}">
                                                            @lang('messages.edit')<i class="la la-edit options-style"></i>
                                                        </a>

                                                    @endcan

                                                    @can('delete_countries', $value)
                                                        @if($value->id !== 1)
                                                        <a class="dropdown-item delete_data" data="{{ $value->id }}" data_name="{{ $value->name['ar']  }}" >
                                                             @lang('messages.delete')<i class="la la-trash options-style"></i>
                                                        </a>
                                                        @endif

                                                    @endcan
                                                </div>
                                            </div>


                                    </td>
                                </tr>

                            @endforeach
                        @endif
                        </tbody>
                    </table>
                    <div class="pagination-rounded">
                        {!! $data->render() !!}
                    </div>

                </div> <!-- end card body-->

            </div> <!-- end card -->
        </div><!-- end col-->
    </div>


@endsection

@section('scripts')

    <script src="{{ URL::asset('admin/libs/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.flash.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.keyTable.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/vfs_fonts.js') }}"></script>
    <!-- Datatables init -->
    <script src="{{ URL::asset('admin/js/pages/datatables.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jszip.min.js') }}"></script>
    <!-- Sweet Alerts js -->
    <script src="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <!-- Sweet alert init js-->
    <script src="{{ URL::asset('admin/js/pages/sweet-alerts.init.js') }}"></script>
    <script>
        $('#datatable-buttons-custom').DataTable( {
            dom: 'Bfrtip',
            buttons: [
                { extend: 'copy', text: "{{trans('messages.copy')}}",exportOptions: {
                        columns: [ 0, 1, 2 ]
                    }  },
                { extend: 'excel', text: "{{trans('messages.excel')}}" ,exportOptions: {
                        columns: [ 0, 1, 2]
                    }},
                { extend: 'print', text: "{{trans('messages.print')}}",exportOptions: {
                        columns: [ 0, 1, 2]
                    } },
            ],
            "oLanguage": {
                "sSearch": "{{trans('messages.search')}}"
            }
        } );
        $(document).ready(function() {

            var CSRF_TOKEN = $('meta[name="X-CSRF-TOKEN"]').attr('content');

            $('body').on('click', '.delete_data', function() {

                var id = $(this).attr('data');
                var swal_text = ' {{trans('messages.Delete')}} الدولة ' + $(this).attr('data_name');
                var swal_title = '{{trans('messages.Are_you_sure_to_delete?')}}';

                Swal.fire({
                    title: swal_title,
                    text: swal_text,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '{{trans('messages.confirm')}}',
                    cancelButtonText: '{{trans('messages.close')}}',
                }).then((result) => {
                    console.log(result.value);
                    if (result.value) {
                        $.ajax({
                            url: "{{ url('/') }}" + "/admin/countries/destroy" ,
                            type: "POST",
                            data: {_token: CSRF_TOKEN, 'id': id},
                        })
                            .done(function(reseived_data) {
                                var parsed_data = $.parseJSON(reseived_data);

                                if(parsed_data.code === '1'){
                                    Swal.fire({
                                        type: 'success',
                                        title: "{{trans('messages.Deletion_successful')}}",
                                        confirmButtonClass: 'btn-success',
                                        confirmButtonText: "{{trans('messages.confirm')}}",
                                    }).then((result) => {
                                        window.location.href = parsed_data.url;
                                    });
                                }
                                else{
                                    Swal.fire(
                                        "{{trans('messages.wrong_operation')}}",
                                        parsed_data.message ,
                                        "error"
                                    );
                                }
                            });
                    }
                });

            });
        });

        function enableUser(id){
            var CSRF_TOKEN = $('meta[name="X-CSRF-TOKEN"]').attr('content');
            var data_str ='';
            if(document.getElementById('customSwitch1'+id).value == 0){
                data_str = "تم الغاء التفعيل "
            }else{
                data_str = "تم التفعيل  "
            }

            $.ajax({
                url: "{{ url('/') }}" + "/admin/countries/change-status" ,
                type: "post",
                data:{_token: CSRF_TOKEN,'status' : document.getElementById('customSwitch1'+id).value , 'id' : id},
                dataType: "json",
                success:function(data) {
                    // console.log(data);
                    Swal.fire({
                        type: 'success',
                        title: data_str,
                        confirmButtonClass: 'btn-success',
                        confirmButtonText: "{{trans('messages.confirm')}}",
                    }).then((result) => {
                        location.reload();
                    });


                }
            });



        }
        function enableDefault(id){
            var CSRF_TOKEN = $('meta[name="X-CSRF-TOKEN"]').attr('content');
            var data_str ='';
            if(document.getElementById('customSwitchDefault'+id).value == 0){
                data_str = "تم الغاء التفعيل "
            }else{
                data_str = "تم التفعيل  "
            }

            $.ajax({
                url: "{{ url('/') }}" + "/admin/countries/change-default" ,
                type: "post",
                data:{_token: CSRF_TOKEN,'status' : document.getElementById('customSwitchDefault'+id).value , 'id' : id},
                dataType: "json",
                success:function(data) {
                    // console.log(data);
                    Swal.fire({
                        type: 'success',
                        title: data_str,
                        confirmButtonClass: 'btn-success',
                        confirmButtonText: "{{trans('messages.confirm')}}",
                    }).then((result) => {
                        location.reload();
                    });


                }
            });



        }
    </script>

@endsection
