@extends('admin.layouts.master')

@section('title')
    تعديل المتجر
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="{{ URL::asset('admin/css/intlTelInput.min.css') }}" />
    <link rel="stylesheet" href="{{ URL::asset('admin/css/bootstrap-fileinput.css') }}">
@endsection

@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.dealers.index') }}">الأعضاء</a></li>
                        <li class="breadcrumb-item active">تعديل المتجر</li>
                    </ol>
                </div>
                <h4 class="page-title">تعديل المتجر</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col-9">
            <div class="card">
                <div class="card-body">
                    {!! Form::model($dealer, ['method' => 'PATCH', 'url' => route('admin.dealers.update', $dealer->id),'class' => 'form-horizontal form-row-seperated parsley-examples', 'files'=> 'true']) !!}

                    <ul class="nav nav-tabs nav-bordered">
                        <li class="nav-item">
                            <a href="#general" data-toggle="tab" aria-expanded="false" class="nav-link active">
                                معلومات المتجر
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#another" data-toggle="tab" aria-expanded="true" class="nav-link">
                                المدن والمناطق
                            </a>
                        </li>
                    </ul>

                    <div class="card-box">
                        <div class="tab-content">
                            @include('admin.dealers._form')


                        </div>
                    </div>
                    {!! Form::close() !!}

                </div>  <!-- end card-body -->
            </div>  <!-- end card -->
        </div>  <!-- end col -->
    </div>
    <!-- end row-->
@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/bootstrap-fileinput.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('select[name="city_id[]"]').on('change', function() {
                var id = $(this).val();
                if(id ==''){
                    $('#regions').empty();
                }else{
                    $.ajax({
                        url: '/get/regions',
                        type: "GET",
                        dataType: "json",
                        data: {ids:id},
                        success:function(data) {

                            if(data['regions'].length > 0){
                                $('#regions').empty();

                                $('#regions').append('<div class="form-group"> <label for="attribute" class="col-lg-3 control-label">المناطق <span class="text-danger">*</span> </label><div class="col-lg-9"><select class="form-control selectpicker" multiple data-live-search="true"  data-style="btn-light" id="region_id" name="region_id[]"  parsley-trigger="change" required >');
                                $('select[name="region_id[]"]').append('<option value> اختر</option>');
                                $.each(data['regions'], function(index , regions) {

                                    $('select[name="region_id[]"]').append('<option value="'+ regions.id +'">'+ regions.name +'</option>');

                                });
                                $('#regions').append(' </select></div></div>');
                                $('.selectpicker').selectpicker('refresh');

                            }else{
                                $('#regions').empty();


                            }


                        }
                    });
                }




            });

        });
    </script>
@endsection

