@extends('admin.layouts.master')

@section('title')
    طلبات الأعضاء
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/select.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <!-- Sweet Alert-->
    <link href="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.dealers.index') }}">الأعضاء</a></li>
                        <li class="breadcrumb-item active">طلبات الأعضاء</li>
                    </ol>
                </div>
                <h4 class="page-title">عرض جميع طلبات العضو {{$dealer->name}}</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-4">طلبات الأعضاء</h4>

                    <table id="datatable-buttons-custom" class="table table-striped dt-responsive nowrap">
                        <thead>
                        <tr>
                            <th> # </th>
                            <th scope="col">رقم الطلب</th>
                            <th scope="col">صاحب الطلب</th>
                            <th scope="col">الجوال</th>
                            <th scope="col">@lang('web.date')</th>
                            <th scope="col">ق الطلب</th>
                            <th scope="col">ق الخصم</th>
                            <th scope="col">ق الشحن</th>
                            <th scope="col">المجموع</th>
                            <th scope="col">طريقة الدفع</th>
                            <th> @lang('messages.operations') </th>
                        </tr>
                        </thead>

                        <tbody>
                        @if($data->count())
                            <?php $i = 0; ?>
                            @foreach( $data as $value )
                                <?php ++$i; ?>
                                <tr>

                                    <td> {{ $i }} </td>
                                    <td class="no_dec"> {{ $value->id }} </td>
                                    <td class="no_dec"><a href="{{ route('admin.users.show', $value->user_id) }}"> {{ \App\Models\User::find($value->user_id)->name }} </a></td>
                                    <td>{{ \App\Models\User::find($value->user_id)->phone }} {{(int)\App\Models\User::find($value->user_id)->country_code}} </td>
                                    <td class="phone-text"> {{ $value->created_at->format('Y-m-d') }}</td>
                                    <td>{{$value->products_total}}</td>
                                    <td>{{$value->total_after_coupon}}</td>
                                    <td>{{$value->shipping_cost ? $value->shipping_cost : 0 }}</td>
                                    <td>{{ $value->all_total }}</td>
                                    <td>
                                        {{\App\Models\PaymentMethod::find($value->payment_method)->name['ar']}}
                                    </td>

                                    <td>

                                        <div class="btn-group mb-2">
                                            <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-chevron-down options-custom"></i>@lang('messages.operations')</button>
                                            <div class="dropdown-menu">

                                                @can('show_orders', \App\Models\Order::class)

                                                    <a class="dropdown-item" href="{{ route('admin.orders.show', $value->id) }}">
                                                        عرض المنتجات<i class="la la-eye options-style"></i>
                                                    </a>

                                                @endcan
                                                @can('show_orders', \App\Models\Order::class)

                                                    <a class="dropdown-item" href="{{ route('admin.orders.orders-details', $value->id) }}">
                                                        عرض تفاصيل الطلب<i class="la la-eye options-style"></i>
                                                    </a>

                                                @endcan
                                                @can('activate_orders',  \App\Models\Order::class)

                                                    <a class="dropdown-item" href="{{ route('admin.orders.change-status-order', $value->id) }}">
                                                        تغيير حالة الطلب<i class="la la-edit options-style"></i>
                                                    </a>


                                                @endcan




                                            </div>
                                        </div>

                                    </td>
                                </tr>

                            @endforeach
                        @endif
                        </tbody>
                    </table>
                    {!! $data->render() !!}

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/libs/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.flash.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.keyTable.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/vfs_fonts.js') }}"></script>
    <!-- Datatables init -->
    <script src="{{ URL::asset('admin/js/pages/datatables.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jszip.min.js') }}"></script>
    <!-- Sweet Alerts js -->
    <script src="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <!-- Sweet alert init js-->
    <script src="{{ URL::asset('admin/js/pages/sweet-alerts.init.js') }}"></script>

    <script>

        $('#datatable-buttons-custom').DataTable( {
            dom: 'Bfrtip',
            buttons: [
                { extend: 'copy', text: "{{trans('messages.copy')}}",exportOptions: {
                        columns: [ 0, 1, 2, 3,4,5 ,7]
                    }  },
                { extend: 'excel', text: "{{trans('messages.excel')}}" ,exportOptions: {
                        columns: [ 0, 1, 2, 3 ,4,5,7]
                    }},
                { extend: 'print', text: "{{trans('messages.print')}}",exportOptions: {
                        columns: [ 0, 1, 2, 3,4,5,7 ]
                    } },
            ],
            "oLanguage": {
                "sSearch": "{{trans('messages.search')}}"
            }
        } );


    </script>
@endsection
