<div class="tab-pane show active" id="general">
    <ul class="nav nav-tabs nav-bordered">
        @foreach(siteLanguages() as $key => $language)
            <li class="nav-item">
                <a href="#tab_{{ $key }}" data-toggle="tab" aria-expanded="false" class="nav-link {{ $key == 'ar' ? 'active' : '' }}"> {{ $language }} </a>
            </li>
        @endforeach

    </ul>
    <div class="tab-content">
        @foreach(siteLanguages() as $key => $language)
            <div class="tab-pane {{ $key == 'ar' ? 'active' : '' }}" id="tab_{{ $key }}">
                <div class="form-group row mb-3">
                    <label for="title[{{ $key }}]" class="col-md-3 col-form-label">اسم المنتج:
                        <span class="text-danger">*</span>
                    </label>
                    <div class="col-9">
                        {!! Form::text("title[$key]", isset($product) ? $product->title[$key] : null, ["parsley-trigger"=>"change", "required" ,'class'=> 'form-control', 'id'=> 'title['.$key.']', 'placeholder'=> $language,  'maxlength'=> "100"]) !!}
                    </div>
                </div>
                <div class="form-group row mb-3">
                    <label for="username[{{ $key }}]" class="col-md-3 col-form-label">تفاصيل المنتج:
                        <span class="text-danger">*</span>
                    </label>
                    <div class="col-9">
                        {!! Form::textarea("description[$key]", isset($product) ? $product->description[$key] : null, ["parsley-trigger"=>"change", "required" ,'class'=> 'form-control', 'id'=> "description_$key", 'placeholder'=> $language]) !!}
                    </div>
                </div>


            </div>

        @endforeach


    </div>
</div>

<div class="tab-pane" id="another">
{{--    @if( ! isset($product))--}}
{{--        <div class="form-group row mb-3">--}}
{{--            <label for="discount" class="col-md-3 col-form-label">ارسال اشعارات:--}}

{{--            </label>--}}

{{--            <div class="col-9">--}}
{{--                <div class="custom-control custom-checkbox">--}}
{{--                    <input type="checkbox" class="custom-control-input" id="customCheck1" value="1" name="send_notification">--}}
{{--                    <label class="custom-control-label" for="customCheck1">ارسال اشعار مع الاضافة</label>--}}
{{--                </div>--}}

{{--            </div>--}}

{{--        </div>--}}
{{--    @endif--}}


    <div class="form-group row mb-3">
        <label for="photos" class="col-md-3 col-form-label">الصور :

        </label>
        <div class="col-9">
            <input type="file" multiple name="photos[]" class="form-control" >

        </div>
    </div>

        @if(isset($product))
            <div class="form-group row mb-3">
                <label for="photos" class="col-md-3 col-form-label">الصور :

                </label>
                <div class="col-9">
                    <ul>
                   @foreach($images as $value)
                        <li>
                            <a class=" delete_data" data="{{ $value->id }}" data_name="{{$value->image }}" >
                                <img src="{{asset('uploads/products/'.$value->image)}}" style="height: 100px; width: 100px" >
                                <img class="close" src="{{asset('admin/images/closeIcon.png')}}" />

                            </a>
                        </li>
                    @endforeach
                    </ul>
                </div>
            </div>
        @endif

    <div class="form-group row mb-3">
        <label for="price" class="col-md-3 col-form-label">السعر :

        </label>
        <div class="col-9">
            <input type="number" min="1"  name="price" class="form-control" placeholder="السعر" value="{{isset($product) ? $product->price : old('price') }}" >

        </div>
    </div>

    <div class="form-group row mb-3">
        <label for="discount" class="col-md-3 col-form-label">الخصم (نسبة مئوية):

        </label>
        <div class="col-9">
            <input type="number" min="1"  name="discount" class="form-control" placeholder="الخصم" value="{{isset($product) ? $product->discount : old('discount') }}" >

        </div>
    </div>


    <div class="form-group row mb-3">
        <label for="range" class="col-md-3 col-form-label">النطاق:
            <span class="text-danger">*</span>
        </label>

        <div class="col-9">
            <select class="form-control selectpicker "  data-live-search="true"  data-style="btn-light" id="range" name="range" parsley-trigger="change" required >
                <option value>اختر النطاق</option>

                    <option value="outside" {{ isset($product) ? ($product->range == "outside" ? "selected" : '') :( old("range") == "outside" ? "selected" : "" ) }}>خارج النطاق</option>
                    <option value="inside" {{ isset($product) ? ($product->range == "inside" ? "selected" : '') :( old("range") == "inside" ? "selected" : "" ) }}>داخل النطاق</option>


            </select>
        </div>
    </div>
        <div class="form-group row mb-3">
            <label for="user_id" class="col-md-3 col-form-label">التاجر:
                <span class="text-danger">*</span>
            </label>

            <div class="col-9">
                <select class="form-control selectpicker "  data-live-search="true"  data-style="btn-light" id="user_id" name="user_id" parsley-trigger="change" required >
                    <option value>اختر التاجر</option>
                    @foreach($users as $value)
                        <option value="{{$value->id}}" {{ isset($product) ? ($product->user_id == $value->id ? "selected" : '') : (old("user_id") == $value->id ? "selected" : "" ) }}>{{$value->name}}</option>

                    @endforeach

                </select>
            </div>
        </div>
    <div class="form-group row mb-3">
        <label for="category_id" class="col-md-3 col-form-label">الاقسام الرئيسية:
            <span class="text-danger">*</span>
        </label>

        <div class="col-9">
            <select class="form-control selectpicker "  data-live-search="true"  data-style="btn-light" id="category_id" name="category_id" parsley-trigger="change" required >
                <option value>اختر القسم</option>
                @foreach($categories as $value)
                    <option value="{{$value->id}}" {{ isset($product) ? ($product->category_id == $value->id ? "selected" : '') : (old("category_id") == $value->id ? "selected" : "" ) }}>{{$value->name['ar']}}</option>

                @endforeach

            </select>
        </div>
    </div>
    <div id="subCategory">
        @if(isset($product)  && $product->sub_category_id !== null )
            <div class="form-group row mb-3">
                <label for="sub_category_id" class="col-md-3 col-form-label">الاقسام الفرعية:
                    <span class="text-danger">*</span>
                </label>

                <div class="col-9">
                    <select class="form-control selectpicker"  data-live-search="true"  data-style="btn-light" id="sub_category_id" name="sub_category_id" parsley-trigger="change" required >
                        <option value>اختر القسم</option>
                        @foreach(\App\Models\Category::whereParentId($product->category_id)->get() as $value)
                            <option value="{{$value->id}}" {{ isset($product) ?( $product->sub_category_id == $value->id ? "selected" : '' ): (old("sub_category_id") == $value->id ? "selected" : "" ) }}>{{$value->name['ar']}}</option>

                        @endforeach

                    </select>
                </div>
            </div>
        @endif

    </div>



</div>

