@extends('admin.layouts.master')

@section('title')
    @lang('messages.settings')
@endsection

@section('styles')
    <link rel="stylesheet" href="{{ URL::asset('admin/css/bootstrap-fileinput.css') }}">
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-colorpicker/bootstrap-colorpicker.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/clockpicker/bootstrap-clockpicker.min.css') }}" rel="stylesheet" type="text/css" />
@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.settings.index') }}">@lang('messages.settings')</a></li>
                        <li class="breadcrumb-item active">فواتير الطلبات</li>
                    </ol>
                </div>
                <h4 class="page-title">@lang('messages.settings')</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-9">
            {!! Form::model($setting, ['method' => 'PATCH', 'url' => route('admin.settings.update-email', $setting->id),'class' => 'form-horizontal form-row-seperated parsley-examples', 'files'=> 'true']) !!}
            <div class="card-box">
                <h4 class="header-title mb-4">@lang('messages.information') @lang('messages.settings')</h4>
                <div class="actions btn-set btn-position" >
                    <button class="btn btn-success" type="submit" >
                        @lang('messages.save')
                    </button>
                </div>


                <ul class="nav nav-tabs nav-bordered">
                    <li class="nav-item">
                        <a href="#general" data-toggle="tab" aria-expanded="false" class="nav-link active">
                            المحتوى
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#another" data-toggle="tab" aria-expanded="true" class="nav-link">
                           لغة الإرسال
                        </a>
                    </li>

                </ul>
                <div class="card-box">
                    <div class="tab-content">
                        @include('admin.settings._form_email')


                    </div>
                </div>
            </div> <!-- end card-box-->
            {!! Form::close() !!}
        </div> <!-- end col -->


    </div>
    <!-- end row -->


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/bootstrap-fileinput.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/moment/moment.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-colorpicker/bootstrap-colorpicker.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/clockpicker/bootstrap-clockpicker.min.js') }}"></script>
    <!-- Init js-->
    <script src="{{ URL::asset('admin/js/pages/form-pickers.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/tiny-custom.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jquery-tiny-custom.js') }}"></script>
    <script src="{{ URL::asset('admin/js/summernote-custom.js') }}"></script>

@endsection
