@extends('admin.layouts.master')

@section('title')
    تعديل اسلايدر
@endsection

@section('styles')
    <link rel="stylesheet" href="{{ URL::asset('admin/css/bootstrap-fileinput.css') }}">
    <link href="{{ URL::asset('admin/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />

    <style>
        .card-box{
            margin-bottom: 47px !important;
        }
    </style>
@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.sliders.index') }}">الاسلايدر</a></li>
                        <li class="breadcrumb-item active">تعديل اسلايدر</li>
                    </ol>
                </div>
                <h4 class="page-title">تعديل اسلايدر</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-9">
            {!! Form::model($slider, ['method' => 'PATCH', 'url' => route('admin.sliders.update', $slider->id),'class' => 'form-horizontal form-row-seperated', 'files'=> 'true']) !!}
            <div class="card-box">
                <h4 class="header-title mb-4">@lang('messages.information') الاسلايدر</h4>
                <div class="actions btn-set btn-position" >
                    <button class="btn btn-success" type="submit" >
                        @lang('messages.save')
                    </button>
                </div>


                <div class="card-box">
                        @include('admin.sliders._form')

                </div>
            </div> <!-- end card-box-->
            {!! Form::close() !!}
        </div> <!-- end col -->


    </div>
    <!-- end row -->


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/js/bootstrap-fileinput.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/moment/moment.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-colorpicker/bootstrap-colorpicker.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/clockpicker/bootstrap-clockpicker.min.js') }}"></script>
    <!-- Init js-->
    <script src="{{ URL::asset('admin/js/pages/form-pickers.init.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('select[name="link_type"]').on('change', function() {
                var id = $(this).val();
                if(id == "category"){
                    $.ajax({
                        url: '/get/categories',
                        type: "GET",
                        dataType: "json",
                        success:function(data) {
                            $('#category').empty();
                            $('#sub_category').empty();
                            $('#link').empty();
                            $('#product').empty();

                            $('#category').append('<div class="form-group row mb-3"> <label for="category_id" class="col-md-3 col-form-label">القسم الرئيسي <span class="text-danger">*</span> </label><div class="col-9"><select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="category_id" name="category_id" parsley-trigger="change" required >');

                            $('select[name="category_id"]').append('<option value>القسم الرئيسي</option>');

                            $.each(data['categories'], function(index , categories) {

                                $('select[name="category_id"]').append('<option value="'+ categories.id +'">'+ categories.name +'</option>');

                            });
                            $('#category').append(' </select></div></div>');
                            $('.selectpicker').selectpicker('refresh');
                        }
                    });
                }
                else if(id == "product"){
                    $.ajax({
                        url: '/get/products',
                        type: "GET",
                        dataType: "json",
                        success:function(data) {
                            $('#sub_category').empty();
                            $('#product').empty();
                            $('#link').empty();
                            $('#category').empty();

                            $('#product').append('<div class="form-group row mb-3"> <label for="product_id" class="col-md-3 col-form-label">المنتجات <span class="text-danger">*</span> </label><div class="col-9"><select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="product_id" name="product_id" parsley-trigger="change" required >');

                            $('select[name="product_id"]').append('<option value>المنتج</option>');
                            // $('select[name="city"]').append('<option value>المدينة</option>');
                            $.each(data['products'], function(index , products) {

                                $('select[name="product_id"]').append('<option value="'+ products.id +'">'+ products.name +'</option>');

                            });
                            $('#product').append(' </select></div></div>');
                            $('.selectpicker').selectpicker('refresh');

                        }
                    });
                }
                else if(id == "external_link"){
                    $('#sub_category').empty();
                    $('#product').empty();
                    $('#link').empty();
                    $('#category').empty();
                    $('#link').append(' <div class="form-group row mb-3"><label for="link" class="col-md-3 col-form-label">رابط خارجي<span class="text-danger">*</span> </label>'+
                        ' <div class="col-9"><input type="text"  name="link" class="form-control" placeholder="رابط خارجي" value="" parsley-trigger="change" required ></div></div>');
                }
                else {
                    $('#product').empty();
                    $('#sub_category').empty();
                    $('#link').empty();
                    $('#category').empty();
                }




            });
            $( "body" ).on( "change", "select[name='category_id']", function() {
                var id = $(this).val();

                $.ajax({
                    url: '/get/subCategories/'+id,
                    type: "GET",
                    dataType: "json",
                    success:function(data) {

                        $('#link').empty();
                        $('#product').empty();
                        $('#sub_category').empty();
                        if (data['categories'].length > 0) {
                            $('#sub_category').append('<div class="form-group row mb-3"> <label for="sub_category_id" class="col-md-3 col-form-label">القسم الفرعي <span class="text-danger">*</span> </label><div class="col-9"><select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="sub_category_id" name="sub_category_id" parsley-trigger="change" required >');

                            $('select[name="sub_category_id"]').append('<option value>القسم الفرعي</option>');

                            $.each(data['categories'], function (index, categories) {

                                $('select[name="sub_category_id"]').append('<option value="' + categories.id + '">' + categories.name + '</option>');

                            });
                            $('#sub_category').append(' </select></div></div>');
                            $('.selectpicker').selectpicker('refresh');
                        }
                    }
                });





            });
        });
    </script>
@endsection
