@extends('admin.layouts.master')

@section('title')
    تغيير حالة الطلب
@endsection
@section('styles')
    <link href="{{ URL::asset('admin/libs/jquery-nice-select/nice-select.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />

@endsection
@section('page_header')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">الاعضاء</a></li>
                        <li class="breadcrumb-item active"> تغيير حالة الطلب</li>
                    </ol>
                </div>
                <h4 class="page-title">  تغيير حالة الطلب <span> <a href="{{ route('admin.users.show', $user->id) }}"> {{ $user->name }} </a> </span>
                </h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col-9">
            <div class="card">
                <div class="card-body">


                    {!! Form::open([ 'url' => route('admin.orders.change-status-update', $order->id), 'class' => 'form-horizontal' ]) !!}

                    <div class="form-group ">
                        <label for="status" class="col-md-3 col-form-label">تغيير حالة الطلب:
                            <span class="text-danger">*</span>
                        </label>

                        <div class="col-9">
                            <select class="selectpicker" data-live-search="true"  data-style="btn-light" id="status" name="status" parsley-trigger="change" required >
                                <option value="in_progress" {{$order->status == "in_progress" ? 'selected' : ''}}>{{getOrderType('in_progress')}}</option>
                                <option value="in_shipping" {{$order->status == "in_shipping" ? 'selected' : ''}}>{{getOrderType('in_shipping')}}</option>
                                <option value="waiting_pay" {{$order->status == "waiting_pay" ? 'selected' : ''}}>{{getOrderType('waiting_pay')}}</option>
                                <option value="waiting_pickup_from_store" {{$order->status == "waiting_pickup_from_store" ? 'selected' : ''}}>{{getOrderType('waiting_pickup_from_store')}}</option>
                                <option value="been_delivered" {{$order->status == "been_delivered" ? 'selected' : ''}}>{{getOrderType('been_delivered')}}</option>
                                <option value="done" {{$order->status == "done" ? 'selected' : ''}}>{{getOrderType('done')}}</option>
                                <option value="cancel_order" {{$order->status == "cancel_order" ? 'selected' : ''}}>{{getOrderType('cancel_order')}}</option>


                            </select>
                        </div>
                    </div>

                    <div class="form-group mb-0 justify-content-end row">
                        <button type="submit" class="btn btn-info waves-effect waves-light"  onclick="this.disabled=true;this.value='تم الارسال, انتظر...';this.form.submit();">  تعديل</button>
                    </div>


                    {!! Form::close() !!}

                </div>  <!-- end card-body -->
            </div>  <!-- end card -->
        </div>  <!-- end col -->
    </div>
    <!-- end row-->

@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.js') }}"></script>
@endsection
