<?php

namespace App\Http\Controllers\Admin;

use App\Models\Contact;
use App\Mail\ReplyContactUs;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    public function index() {

        $this->authorize('view_contacts', Contact::class);

        $data = Contact::orderBy('id', 'DESC')->paginate(10);
        return view('admin.contacts.index', compact('data'));
    }

    public function show(Contact $contact) {

        $this->authorize('show_contacts', $contact);

        if(!$contact->is_read)
            $contact->update([ 'is_read' => true ]);

        return view('admin.contacts.show', compact('contact'));
    }

    public function replyMessage($id,Request $request) {

        $headingTitle   = 'Reply From Admin To Your Message';
        $data           = Contact::find($id);
        $data->update(['reply' => $request->msg_body]);

        $this->sendEmail($data->email, $request->msg_body, $headingTitle, $data->message);

        $url = route('admin.contacts.show', $request->id);
        return $url ?
            redirect()->route('admin.contacts.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.contacts.index')->with('warning', trans('messages.addNO'));
    }

    public function destroy(Request $request){

        $deleted = Contact::where('id', $request->id)->delete();
        $url = route('admin.contacts.index');

        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }

    protected function sendEmail($userEmail, $messageReply, $headingTitle, $userMessage) {

        $data = [
            'mailSubject'   => 'Contact Us Reply Message',
            'headingTitle'  => $headingTitle,
            'message'       => $messageReply,
            'userMessage'   => $userMessage
        ];

        Mail::to($userEmail)->send(new ReplyContactUs($data));

        if( count(Mail::failures()) > 0 ) {
            Mail::to($userEmail)->send(new ReplyContactUs($data));

            if( count(Mail::failures()) > 0 ) {
                Mail::to($userEmail)->send(new ReplyContactUs($data));
            }
        }
    }

}
