<?php

namespace App\Http\Controllers\Admin;


use App\Models\User;
use App\Models\UserDevice;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class NotificationController extends Controller
{

    public function create($type) {

        if($type == 'all')
            $users = User::select('name', 'email', 'id')->get();
        else
            abort('404');

        return view('admin.notifications.create', compact('type', 'users'));
    }


    public function store(Request $request, $type){



        if($type == 'all') {

            $request->validate([
                'user'      => 'required',
                'message'   => 'required|array',
                'title'   => 'required|array',
                'message.*'   => 'required',
                'title.*'   => 'required',
            ]);

            $notificationTitle = array(
                'ar'=>$request->title['ar'],
                'en'=>$request->title['en'],
            );
            $notificationMessage = array(
                'ar'=>$request->message['ar'],
                'en'=>$request->message['en'],

            );
            $all_data_ar = array(
                'title'=>$request->title['ar'],
                'body'=>$request->message['ar'],
                'type'=>1,
                'seen'=>0,
                'notifiable_id'=>null,
                'sound' => 'default',
//                'click_action' => 'FCM_PLUGIN_ACTIVITY',
            );

            $all_data_en = array(
                'title'=>$request->title['en'],
                'body'=>$request->message['en'],
                'type'=>1,
                'seen'=>0,
                'notifiable_id'=>null,
                'sound' => 'default',
//                'click_action' => 'FCM_PLUGIN_ACTIVITY',
            );


            if($request->user == 'all') {
                $usersIds       = User::get()->pluck('id')->toArray();
//                $devicesTokens  = UserDevice::whereIn('user_id', $usersIds)
//                                            ->where('is_open', true)
//                                            ->orderBy('updated_at', 'DESC')
//                                            ->pluck('firebase_token')
//                                            ->toArray();
                foreach ($usersIds as $id)
                    saveNotification($id, 1, serialize($notificationTitle) , serialize($notificationMessage) );

                sendTopicNotification($all_data_ar,'all_ar');
                sendTopicNotification($all_data_en,'all_en');

                return redirect()->route('admin.notifications.create', $type)->with('success', 'تم الإرسال بنجاح');
            }elseif($request->user == 'users') {
                $usersIds       = User::where('user_type','user')->get()->pluck('id')->toArray();
                foreach ($usersIds as $id)
                    saveNotification($id, 1, serialize($notificationTitle) , serialize($notificationMessage) );

                sendTopicNotification($all_data_ar,'all_users_ar');
                sendTopicNotification($all_data_en,'all_users_en');

                return redirect()->route('admin.notifications.create', $type)->with('success', 'تم الإرسال بنجاح');
            }elseif($request->user == 'dealers') {
                $usersIds       = User::where('user_type','dealer')->get()->pluck('id')->toArray();

                foreach ($usersIds as $id)
                    saveNotification($id, 1, serialize($notificationTitle) , serialize($notificationMessage) );

                sendTopicNotification($all_data_ar,'dealers_ar');
                sendTopicNotification($all_data_en,'dealers_en');

                return redirect()->route('admin.notifications.create', $type)->with('success', 'تم الإرسال بنجاح');
            }
            else {
                $all_data = array(
                    'title'=>$notificationTitle[User::find($request->user)->language],
                    'body'=>$notificationMessage[User::find($request->user)->language],
                    'type'=>1,
                    'seen'=>0,
                    'notifiable_id'=>null,
                    'sound' => 'default',
//                    'click_action' => 'FCM_PLUGIN_ACTIVITY',
                );
                saveNotification($request->user, 1, serialize($notificationTitle), serialize($notificationMessage) );

                $devicesTokens  = UserDevice::where('user_id', $request->user)
//                                            ->where('is_open', true)
                                            ->orderBy('updated_at', 'DESC')
                                            ->pluck('firebase_token')
                                            ->toArray();
            }
            if($devicesTokens)
                sendMultiNotification($all_data, $devicesTokens);

            return redirect()->route('admin.notifications.create', $type)->with('success', 'تم الإرسال بنجاح');
        }
        abort('404');
    }
}
