<?php

namespace App\Http\Controllers\Api;


use App\Http\Resources\AllCitiesDealerResource;
use App\Http\Resources\AllCitiesResource;
use App\Models\Question;
use App\Models\Region;
use App\Models\Setting;
use App\Models\UserDevice;
use App\Http\Controllers\Controller;

class ApiController extends Controller
{



    public function get_cities() {


        $data = Region::whereParentId(null)->get();
        $data->map(function ($city){
            $city['name'] =$city->name[app()->getLocale()];
            return $city;
        });
        $data->makeHidden(['created_at','parent_id','updated_at','shipping_cost'])->toArray();



        return ApiController::respondWithSuccess($data);


    }

    public function get_region($id) {


        $data = Region::whereParentId($id)->get();
        $data->map(function ($city){
            $city['name'] =$city->name[app()->getLocale()];
            return $city;
        });
        $data->makeHidden(['created_at','parent_id','updated_at','shipping_cost'])->toArray();



        return ApiController::respondWithSuccess($data);


    }
    public function all_regions_cities() {


    $data = AllCitiesResource::collection(Region::whereParentId(null)->get());
    return ApiController::respondWithSuccess($data);


    }
    public function all_regions_cities_for_dealer() {


    $data = AllCitiesDealerResource::collection(Region::whereParentId(null)->get());
    return ApiController::respondWithSuccess($data);


    }
    public function questions() {


        $data = Question::get();
        $data->map(function ($question){
            $question['question'] = unserialize($question->title)[app()->getLocale()];
            $question['answer'] =unserialize($question->text)[app()->getLocale()];
            return $question;
        });
        $data->makeHidden(['created_at','updated_at','title','text'])->toArray();



        return ApiController::respondWithSuccess($data);


    }


    public function getPage($type) {


        $data = Setting::where('id', 1)->select($type)->first();

        if ($data)
            $pageData = unserialize($data[$type])[app()->getLocale()];
        else
            $pageData = NULL;

        return ApiController::respondWithSuccess($pageData);


    }

    public static function createUserDeviceToken($userId, $deviceToken, $deviceType) {

        if (! UserDevice::where('device_identifier',$deviceType)->where('firebase_token',$deviceToken)->where('user_id',$userId)->first()){
            $created = UserDevice::create(['user_id' => $userId, 'device_identifier' => $deviceType, 'firebase_token' => $deviceToken]);
            return $created;
        }

    }

    public static function respondWithSuccess($data) {
        http_response_code(200);
        return response()->json(['mainCode'=> 1,'code' =>  http_response_code()  , 'data' => $data])->setStatusCode(200);
    }
    public static function respondWithSuccessMessage($data) {
        http_response_code(200);
        return response()->json(['mainCode'=> 1,'code' =>  http_response_code() , 'message'=> $data])->setStatusCode(200);
    }


    public static function respondWithError($errors) {
        http_response_code(422);  // set the code
        return response()->json(['mainCode'=> 0,'error_code'=> 0,'code' =>  http_response_code() ,  'error' => $errors])->setStatusCode(422);
    }
    public static function respondWithErrorCart($errors) {
        http_response_code(422);  // set the code
        return response()->json(['mainCode'=> 0,'error_code'=> 100,'code' =>  http_response_code() ,  'error' => $errors])->setStatusCode(422);
    }
    public static function respondWithErrorNOTFound($errors) {
        http_response_code(404);  // set the code
        return response()->json(['mainCode'=> 0,'code' =>  http_response_code()  , 'error' => $errors])->setStatusCode(404);
    }
    public static function respondWithSuccessStatus($status,$data=null) {
        http_response_code(200);
        if ($data)
        return response()->json(['mainCode'=> 1,'code' =>  http_response_code() ,'status'=>$status ,'data' => $data])->setStatusCode(200);
        return response()->json(['mainCode'=> 1,'code' =>  http_response_code() ,'status'=>$status ])->setStatusCode(200);
    }
    public static function respondWithErrorClient($errors) {
        http_response_code(400);  // set the code
        return response()->json(['mainCode'=> 0,'error_code'=> 0,'code' =>  http_response_code() ,  'error' => $errors])->setStatusCode(400);
    }

    public static function respondWithErrorAuth($errors) {
        http_response_code(401);  // set the code
        return response()->json(['mainCode'=> 0,'error_code'=> 0,'code' =>  http_response_code() , 'error' => $errors])->setStatusCode(401);
    }


    public static function respondWithServerError() {
        $errors = trans('messages.error_500');
        http_response_code(500);
        return response()->json(['mainCode'=> 0,'code' =>  http_response_code(),  'error' => $errors])->setStatusCode(500);
    }




}
