<?php

namespace App\Http\Controllers\Api\Dealer;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use Facade\FlareClient\Api;
use Illuminate\Http\Request;

class RegionController extends Controller
{
    //
    public function all_region(){
        $regions = \request()->user()->regions()->get()->pluck('parent_id')->toArray();
        $all_regions = \request()->user()->regions()->select('regions.id','regions.parent_id')->get();

        $unique = array_unique($regions);
        $all = [];

        foreach ($unique as $key => $data){

            $all[$key]['city']= $data ;
            $all[$key]['region']= [] ;

            foreach ($all_regions as $value){
                if ($data == $value->parent_id){
                    array_push($all[$key]['region'],$value->id);

                }
            }
        }
        return  ApiController::respondWithSuccess($all);
    }
    public function edit_cities_regions(Request $request){
        $regions = $request->regions;
        if ($regions == null){
            return ApiController::respondWithError(trans('messages.region_required'));
        }
        $request->user()->regions()->sync( $regions );
        $regions = \request()->user()->regions()->get()->pluck('parent_id')->toArray();
        $all_regions = \request()->user()->regions()->select('regions.id','regions.parent_id')->get();

        $unique = array_unique($regions);
        $all = [];

        foreach ($unique as $key => $data){

            $all[$key]['city']= $data ;
            $all[$key]['region']= [] ;

            foreach ($all_regions as $value){
                if ($data == $value->parent_id){
                    array_push($all[$key]['region'],$value->id);

                }
            }
        }
        return  ApiController::respondWithSuccess($all);
    }
}
