<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\User\AddAddressRequest;
use App\Http\Requests\Api\User\DefaultAddressRequest;
use App\Http\Requests\Api\User\EditAddressRequest;
use App\Http\Resources\User\AddressResource;
use App\Models\Address;
use Illuminate\Http\Request;

class AddressController extends Controller
{
    //
    public function get_addresses(){

        $addresses=\request()->user()->addresses()->paginate(10);

        AddressResource::collection($addresses);
        return ApiController::respondWithSuccess($addresses);
    }
    public function add_address(AddAddressRequest $request){

        $request['user_id']=$request->user()->id;
        if ($request->user()->addresses()->count() == 0){
            $request['default_address']=  1;
        }
        $address= Address::create($request->all());
        $data = new AddressResource($address);
        return ApiController::respondWithSuccess($data);
    }
    public function edit_address(EditAddressRequest $request){

        $address= Address::find($request->address_id);
        $created = $address->update([
            'phone'=>$request->phone ? $request->phone : $address->phone,
            'street_name'=>$request->street_name ? $request->street_name : $address->street_name,
            'building_number'=>$request->building_number ? $request->building_number : $address->building_number,
            'lat'=>$request->lat ? $request->lat : $address->lat,
            'lng'=>$request->lng ? $request->lng : $address->lng,
            'floor_number'=>$request->floor_number ? $request->floor_number : $address->floor_number,
            'apartment_number'=>$request->apartment_number ? $request->apartment_number : $address->apartment_number,
            'description'=>$request->description ? $request->description : $address->description,
        ]);
        $data = new AddressResource(Address::find($request->address_id));

        return $created
            ? ApiController::respondWithSuccess($data)
            : ApiController::respondWithServerError();
    }
    public function toggle_default_address(DefaultAddressRequest $request){

        $address= Address::find($request->address_id);
        if ($request->default_address == 1){
            $request->user()->addresses()->where('default_address',1)->update(['default_address'=>0]);
        }
        $created = $address->update([
            'default_address'=>$request->default_address,

        ]);
        $data = new AddressResource(Address::find($request->address_id));

        return $created
            ? ApiController::respondWithSuccess($data)
            : ApiController::respondWithServerError();

    }
    public function delete_address($id){

        $address= Address::find($id);
        if (! $address){
            return ApiController::respondWithServerError();
        }
        $address->delete();

        return  $address
            ? response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200)
            : ApiController::respondWithServerError();

    }

}
