<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Models\Bank;
use Illuminate\Http\Request;

class BankController extends Controller
{
    //
    public function banks(){
        $banks = Bank::select('id','bank_name','image','name','account_number','height','width')->get();
        $banks->map(function ($bank){
           $bank['bank_name']=$bank->bank_name[app()->getLocale()] ;
           $bank['name']=$bank->name[app()->getLocale()] ;
           $bank['image_path']='/uploads/banks/' ;
           $bank['image']=$bank->image ;
           return $bank;
        });

        return ApiController::respondWithSuccess($banks);
    }
}
