<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Resources\User\CategoryResource;
use App\Http\Resources\User\HomeProductResource;
use App\Http\Resources\User\SubCategoryResource;
use App\Models\Category;
use App\Models\Product;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function categories(Request $request)
    {

        $categories = Category::whereParentId(null)->orderBy('id','desc')->paginate(10);
        CategoryResource::collection($categories);
        return ApiController::respondWithSuccess($categories);
    }
    public function sub_categories($id ,Request $request)
    {

        $categories = Category::whereParentId($id)->orderBy('id','desc')->paginate(10);
        SubCategoryResource::collection($categories);
        return ApiController::respondWithSuccess($categories);
    }
    public function all_products(Request $request){
        $city_id= $request->header('city-id');
        $region_id= $request->header('region-id');
        $categoryId = $request->category_id;
        if($categoryId != -1){
            $categoryId = Category::find($request->category_id);
            if($categoryId == null){
                $errors = trans('messages.not_found');
                return ApiController::respondWithError($errors);
            }
            if ($request->filter == "newest"){
                if($categoryId){
                    if($categoryId->parent_id == null){
                        if ($request->name !== null){
                            $products = Product::whereRange('outside')->where('type','product')->whereCategoryId($categoryId->id)
                                ->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                })->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })->whereCategoryId($categoryId->id)->where('type','product')->orderBy('id','desc')->paginate(10);
                        }
                        else{
                            $products = Product::whereRange('outside')->where('type','product')->whereCategoryId($categoryId->id)
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                })->whereCategoryId($categoryId->id)->where('type','product')->orderBy('id','desc')->paginate(10);

                        }


                    }else{
                        if ($request->name !== null){
                            $products = Product::whereRange('outside')->where('type','product')->where('sub_category_id',$categoryId->id)
                                ->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                }) ->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })
                                ->where('sub_category_id',$categoryId->id)->where('type','product')->orderBy('id','desc')->paginate(10);
                        }
                        else{
                            $products = Product::whereRange('outside')->where('type','product')->where('sub_category_id',$categoryId->id)
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                })->where('sub_category_id',$categoryId->id)->where('type','product')->orderBy('id','desc')->paginate(10);

                        }


                    }
                }
            }
            elseif ($request->filter == "most_seller"){

                if($categoryId){
                    if($categoryId->parent_id == null){
                        if ($request->name !== null){
                            $products = Product::where('type','product')->whereRange('outside')->whereCategoryId($categoryId->id)
                                ->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                }) ->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })
                                ->whereCategoryId($categoryId->id)->where('type','product')->orderBy('sold','desc')->paginate(10);
                        }else{

                            $products = Product::where('type','product')->whereRange('outside')->whereCategoryId($categoryId->id)
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                })->whereCategoryId($categoryId->id)->where('type','product')->orderBy('sold','desc')->paginate(10);

                        }
                    }else{
                        if ($request->name !== null){
                            $products = Product::where('type','product')->whereRange('outside')->where('sub_category_id',$categoryId->id)
                                ->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                })
                                ->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })
                                ->where('sub_category_id',$categoryId->id)->where('type','product')->orderBy('sold','desc')->paginate(10);
                        }else{
                            $products = Product::where('type','product')->whereRange('outside')->where('sub_category_id',$categoryId->id)
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                })->where('sub_category_id',$categoryId->id)->where('type','product')->orderBy('sold','desc')->paginate(10);

                        }

                    }
                }
            }
            else{
                if($categoryId){
                    if($categoryId->parent_id == null){
                        if ($request->name !== null){

                            $products = Product::whereRange('outside')->where('type','product')->whereCategoryId($categoryId->id)
                                ->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                }) ->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })
                                ->whereCategoryId($categoryId->id)->where('type','product')->orderBy('id','desc')->paginate(10);
                        }else{
                            $products = Product::whereRange('outside')->where('type','product')->whereCategoryId($categoryId->id)
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                })->whereCategoryId($categoryId->id)->where('type','product')->orderBy('id','desc')->paginate(10);
                        }

                    }else{
                        if ($request->name !== null){

                            $products = Product::whereRange('outside')->where('type','product')->where('sub_category_id',$categoryId->id)
                                ->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                }) ->where(function ($q) use ($request) {
                                    $q->where('title->ar', 'like', $request->name . '%')
                                        ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                    $q->where('title->en', 'like', $request->name . '%')
                                        ->orWhere('title->en', 'like', '%' . $request->name . '%');
                                })
                                ->where('sub_category_id',$categoryId->id)->where('type','product')->orderBy('id','desc')->paginate(10);
                        }else{
                            $products = Product::whereRange('outside')->where('type','product')->where('sub_category_id',$categoryId->id)
                                ->orWhereHas('user',function ($q)use ($region_id){
                                    $q->whereHas('regions',function ($q2) use ($region_id){
                                        $q2->where('region_id',$region_id);
                                    });
                                })->where('sub_category_id',$categoryId->id)->where('type','product')->orderBy('id','desc')->paginate(10);
                        }

                    }
                }
            }

        }
        else{

            if ($request->product_type == "special"){
                if ($request->filter == "newest"){
                    if ($request->name !== null){

                        $products = Product::whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }else{
                        $products = Product::whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }

                }
                elseif ($request->filter == "most_seller"){
                    if ($request->name !== null){

                        $products = Product::whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)
                            ->orderBy('sold','desc')->paginate(10);
                    }else{
                        $products = Product::whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)
                            ->orderBy('sold','desc')->paginate(10);
                    }

                }
                else{
                    if ($request->name !== null){

                        $products = Product::whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }else{
                        $products = Product::whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->whereSpecial(1)->whereStatus(0)->where('type','product')->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }

                }

            }
            elseif ($request->product_type == "most_seller"){
                if ($request->filter == "newest"){
                    if ($request->name !== null){

                        $products = Product::where('type','product')->whereStatus(0)->whereActive(1)->whereRange('outside')
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->whereStatus(0)->where('type','product')->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }else{
                        $products = Product::where('type','product')->whereStatus(0)->whereActive(1)->whereRange('outside')
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->whereStatus(0)->where('type','product')->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }

                }
                elseif ($request->filter == "most_seller"){
                    if ($request->name !== null){

                        $products = Product::whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->whereStatus(0)->where('type','product')->whereActive(1)->orderBy('sold','desc')->paginate(10);
                    }else{

                        $products = Product::whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->whereStatus(0)->where('type','product')->whereActive(1)->orderBy('sold','desc')->paginate(10);
                    }
                }
                else{
                    if ($request->name !== null){

                        $products = Product::whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->whereStatus(0)->where('type','product')->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }else{
                        $products = Product::whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->whereStatus(0)->where('type','product')->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }

                }
            }
            elseif ($request->product_type == "discount"){
                if ($request->filter == "newest"){
                    if ($request->name !== null){

                        $products = Product::where('discount','!=',null)->where('type','product')->whereStatus(0)->whereActive(1)->whereRange('outside')
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->where('discount','!=',null)->whereStatus(0)
                            ->where('type','product')->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }else{
                        $products = Product::where('discount','!=',null)->where('type','product')->whereStatus(0)->whereActive(1)->whereRange('outside')
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->where('discount','!=',null)->whereStatus(0)
                            ->where('type','product')->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }

                }
                elseif ($request->filter == "most_seller"){
                    if ($request->name !== null){
                        $products = Product::where('discount','!=',null)->whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->where('discount','!=',null)->whereStatus(0)->where('type','product')
                            ->whereActive(1)->orderBy('sold','desc')->paginate(10);
                    }else{
                        $products = Product::where('discount','!=',null)->whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->where('discount','!=',null)->whereStatus(0)->where('type','product')
                            ->whereActive(1)->orderBy('sold','desc')->paginate(10);

                    }

                }
                else{
                    if ($request->name !== null){

                        $products =  Product::where('discount','!=',null)->whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->where('discount','!=',null)->whereStatus(0)->where('type','product')
                            ->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }else{
                        $products =  Product::where('discount','!=',null)->whereStatus(0)->where('type','product')->whereActive(1)->whereRange('outside')
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->where('discount','!=',null)->whereStatus(0)->where('type','product')
                            ->whereActive(1)->orderBy('id','desc')->paginate(10);
                    }

                }
            }
            elseif($request->product_type == "all"){
                if ($request->filter == "newest"){
                    if ($request->name !== null){

                        $products = Product::whereRange('outside')->where('type','product')->whereActive(1)
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orderBy('id','desc')->whereActive(1)->where('type','product')->paginate(10);
                    }else{
                        $products = Product::whereRange('outside')->where('type','product')->whereActive(1)
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->orderBy('id','desc')->where('type','product')->whereActive(1)->paginate(10);
                    }


                }
                elseif ($request->filter == "most_seller"){
                    if ($request->name !== null){

                        $products = Product::where('type','product')->whereRange('outside')->whereActive(1)
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->where('type','product')->whereActive(1)->orderBy('sold','desc')->paginate(10);
                    }else{
                        $products = Product::where('type','product')->whereRange('outside')->whereActive(1)
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->where('type','product')->whereActive(1)->orderBy('sold','desc')->paginate(10);
                    }


                }
                else{
                    if ($request->name !== null){

                        $products = Product::whereRange('outside')->where('type','product')->whereActive(1)
                            ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            }) ->where(function ($q) use ($request) {
                                $q->where('title->ar', 'like', $request->name . '%')
                                    ->orWhere('title->ar', 'like', '%' . $request->name . '%');
                                $q->where('title->en', 'like', $request->name . '%')
                                    ->orWhere('title->en', 'like', '%' . $request->name . '%');
                            })
                            ->orderBy('id','desc')->whereActive(1)->where('type','product')->paginate(10);
                    }else{
                        $products = Product::whereRange('outside')->whereActive(1)->where('type','product')
                            ->orWhereHas('user',function ($q)use ($region_id){
                                $q->whereHas('regions',function ($q2) use ($region_id){
                                    $q2->where('region_id',$region_id);
                                });
                            })->orderBy('id','desc')->whereActive(1)->where('type','product')->paginate(10);
                    }


                }
            }

        }






        HomeProductResource::collection($products);
        return ApiController::respondWithSuccess($products);
    }
}
