<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\RoomRequest;
use App\Http\Requests\Api\SendMessageRequest;
use App\Http\Requests\Api\UploadFileRequest;
use App\Http\Requests\Api\User\StartOrderRequest;
use App\Http\Resources\ChatMessageResource;
use App\Http\Resources\RoomResource;
use App\Models\Chat;
use App\Models\Product;
use App\Models\Room;
use App\Models\User;
use Illuminate\Http\Request;

class ChatController extends Controller
{
    //
    public function start_chat_order(StartOrderRequest $request){
        $product = Product::find($request->product_id);
        if($product == null){
            $errors = trans('messages.not_found');
            return ApiController::respondWithError($errors);
        }
        $room = Room::whereSenderId($request->user()->id)
            ->whereReceiverId($product->user_id)->first();
        if ($room){
            if ($request->order == "new_order"){
                Chat::create([
                    'sender_id'=>$request->user()->id,
                    'senderable_type'=>"user",
                    'room_id'=>$room->id,
                    'gift_id'=>$product->id,
                    'giftable_type'=>"App\Product",
                    'type'=>"gift",
                ]);
            }
            $data = [
                'room_id'=>$room->id
            ];
            $room->update(['sender_online'=>1]);
            return ApiController::respondWithSuccess($data);

        }else{
            $newRoom =  Room::create([
                'sender_id'=>$request->user()->id,
                'receiver_id'=>$product->user_id,
                'sender_online'=>1
            ]);
            if ($request->order == "new_order"){
                Chat::create([
                    'sender_id'=>$request->user()->id,
                    'senderable_type'=>"user",
                    'room_id'=>$newRoom->id,
                    'gift_id'=>$product->id,
                    'giftable_type'=>"App\Product",
                    'type'=>"gift",
                ]);
            }

            $data = [
                'room_id'=>$newRoom->id
            ];
            return ApiController::respondWithSuccess($data);
        }

    }

    public function chat_details($id , Request $request){

        $chat=Chat::where('room_id',$id)->orderBy('id','desc')->paginate(10);
        ChatMessageResource::collection($chat);

        //update chat messages to seen
        Chat::where('room_id',$id)->where('seen',0)->where('sender_id','!=',$request->user()->id)->update(['seen'=>1]);
        return ApiController::respondWithSuccess($chat);
    }

    public function get_rooms(Request $request){

        $rooms=Room::where('sender_id', $request->user()->id)
            ->orWhere('receiver_id', $request->user()->id)
            ->orderBy('updated_at','desc')->paginate(10);

        RoomResource::collection($rooms);
        return ApiController::respondWithSuccess($rooms);

    }

    public function send_message(SendMessageRequest $request){


        $request['sender_id']=$request->user()->id;
        $request['senderable_type']=$request->senderable_type;
        $request['type']=$request->file_type;
        $room = Room::whereId($request->room_id)
            ->where('sender_online',1)->where('receiver_online',1)->first();
        if ($room){
            $request['seen']=1;
            $room->update(['seen'=>1]);
        }
        else{
            $room = Room::find($request->room_id);
            if ($request->file_type == "file"){
                $message = app()->getLocale() == "ar"? "ملف" :"file";
            }elseif($request->file_type == "image"){
                $message = app()->getLocale() == "ar"? "صورة" :"image";
            }elseif($request->file_type == "voice"){
                $message = app()->getLocale() == "ar"? "ملف صوتي" :"voice";
            }elseif($request->gift_id !== null){
                $message = app()->getLocale() == "ar"? " هديتك" :"Your Gift";
            }elseif($request->file_type == "text" ){
                $message = $request->message;
            }
            if ($room->sender_online == 0){
                /* notifications*/
                $title = array(
                    'ar'=>User::find($room->receiver_id)->name,
                    'en'=>User::find($room->receiver_id)->name,
                );
                $messages = array(
                    'ar'=>isset($message)?$message:'',
                    'en'=>isset($message)?$message:'',
                );
                sendChatMobileNotification($room->sender_id,$room->receiver_id,$title,$messages,4,$room->id);
                /*end notifications*/
            }elseif($room->receiver_online == 0){
                /* notifications*/
                $title = array(
                    'ar'=>User::find($room->sender_id)->name,
                    'en'=>User::find($room->sender_id)->name,
                );
                $messages = array(
                    'ar'=>isset($message)?$message:'',
                    'en'=>isset($message)?$message:'',
                );
                sendChatMobileNotification($room->receiver_id,$room->sender_id,$title,$messages,4,$room->id);
                /*end notifications*/


                }


            $room->update(['seen'=>0]);
        }
        $chat =  Chat::create($request->all());
        $data=  new ChatMessageResource($chat);
        return response()->json(['data'=>$data],200);

    }

    public function connect_room(RoomRequest $request){


        $room= Room::find($request->room_id);
        if ($room->sender_id == $request->user()->id){
            $room->update(['sender_online'=>1]);
        }else{
            $room->update(['receiver_online'=>1]);
        }
        return response()->json(['mainCode'=> 1,'code' =>  200 , 'user_phone'=>$request->user()->phone ],200);

    }
    public function disconnect_room(RoomRequest $request){

        $room= Room::find($request->room_id);
        if ($room->sender_id == $request->user()->id){
            $room->update(['sender_online'=>0]);
        }else{
            $room->update(['receiver_online'=>0]);
        }

        return response()->json(['mainCode'=> 1,'code' =>  200,'id'=>$request->user()->id,'sender_online'=> Room::find($request->room_id)],200);

    }
    public function uploadFileForChat(UploadFileRequest $request){

        if($request->file !== null){
            $data = UploadImage($request->file('file'), 'file', '/uploads/chats');
        }

        if ($data){
            $data=[
                'file'=>$data,
                'file_path'=>'/uploads/chats/',
            ];
            return ApiController::respondWithSuccess($data);
        }
    }

}
