<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class ProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if( $this->method() == 'PATCH' ) {

            return [
                'title'                  => 'required|array',
                'title.*'                  => 'required|string',
                'description'                  => 'required|array',
                'description.*'                  => 'required|string',
                "category_id"                => "required",
                "price"                => "required|numeric",
                "discount"                => "nullable|numeric",
                "photos"                => "nullable|array",
                "photos.*"                => "nullable|mimes:jpg,gif,jpeg,png,tiff",

            ];
        }
        return [
            'title'                  => 'required|array',
            'title.*'                  => 'required|string',
            'description'                  => 'required|array',
            'description.*'                  => 'required|string',
            "category_id"                => "required",
            "price"                => "required|numeric",
            "discount"                => "nullable|numeric",
            "photos"                => "required|array",
            "photos.*"                => "required|mimes:jpg,gif,jpeg,png,tiff",
        ];
    }
}
