<?php

namespace App\Http\Requests\Api;

use App\Http\Requests\RequestApiParent;

class ContactUsRequest extends RequestApiParent
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name'      => 'required|max:255',
            'email'     =>  ['required', 'email', 'max:255','regex:/^\S*$/u'],
            'message'   => 'required',
            'phone' =>['required','regex:/^(009665|9665|\+9665|05|5)(5|0|3|6|4|9|1|8|7)([0-9]{7})$/'],
        ];
    }
}
