<?php

namespace App\Http\Requests\Api\Dealer;

use App\Http\Requests\RequestApiParent;

class AddGiftRequest extends RequestApiParent
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            "photos"                => "required_if:type,add|nullable|array",
            "photos.*"                => "required_if:type,add|nullable|mimes:jpg,gif,jpeg,png,tiff",
            'title'                  => 'required|string',
            'description'                  => 'required|string',
            "price"                => "required|numeric",
            "room_id"                => "required|exists:rooms,id",
            "type"                => "required|in:edit,add",
            "range"                => "required_if:type,add|nullable|in:outside,inside",
            "gift_id"                => "required_if:type,edit|nullable|exists:products,id",


        ];
    }
}
