<?php

namespace App\Http\Requests\Api\Dealer;

use App\Http\Requests\RequestApiParent;

class PullBalanceRequest extends RequestApiParent
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'phone' =>['required', 'regex:/^(009665|9665|\+9665|05|5)(5|0|3|6|4|9|1|8|7)([0-9]{7})$/'],
            'name'           => 'required|string',
            'bank_name'           => 'required|string',
            'iban'           => 'required|max:191',
            'balance'           => 'required|numeric',

        ];
    }
}
