<?php

namespace App\Http\Resources;

use App\Models\Employee;
use App\Models\Gift;
use App\Models\Order;
use App\Models\OrderService;
use App\Models\Product;
use App\Models\Rate;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class ChatMessageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {

        $data= [
            'id' => $this->id,
            'room_id' => $this->room_id,
            'message' =>  $this->message,
            'sender_id' =>(int) $this->sender_id,
            'sender_type' =>$this->senderable_type,
            'sender_image_path'=>'/uploads/users/',
            'sender_image'  => $this->user->image,
            'sender_name' => $this->user->name,
            'height' => $this->user->height,
            'width' => $this->user->width,
            'seen' => $this->seen,
            'file_path' =>'/uploads/chats/',
            'file' =>$this->file? $this->file : '',
            'file_type' => $this->type,
            'duration' => $this->duration,
            'gift'=>$this->gift_id  ?( $this->giftable_type == "App\Product" ?  new ProductResource(Product::withTrashed()->find($this->gift_id)) :new GiftResource(Product::withTrashed()->find($this->gift_id)) )   : null,
            'time'=> Carbon::now()->format('y-m-d') == Carbon::parse($this->created_at)->format('y-m-d') ? Carbon::parse($this->created_at)->format('h:i A') : Carbon::parse($this->created_at)->format('M d h:i A'),
            'created_at'=> $this->created_at->format('Y-m-d H:i:s') ,

        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}

