<?php

namespace App\Http\Resources\Dealer;

use Illuminate\Http\Resources\Json\JsonResource;


class LoginResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function __construct($resource, $token = null)
    {
        // Ensure you call the parent constructor
        parent::__construct($resource);
        $this->resource = $resource;

        $this->token = $token;
    }
    public function toArray($request)
    {



       $data= [
            'id' => $this->id,
            'phone'                 =>$this->phone,
            'name'                 => $this->name,
            'email'                 => $this->email,
            'description'                 => $this->description,
            'image_path'=>'/uploads/users/',
            'image'=>$this->image ,
            'height' => $this->height,
            'width' => $this->width,
//            'active'            => $this->active ? true : false,
            'api_token' => $this->token,
            'regions'=>$this->regions()->get()->pluck('id')->toArray()
//            'language' => $this->language,
        ];

        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
