<?php

namespace App\Http\Resources\Dealer;


use App\Models\PaymentMethod;
use App\Models\ProductRate;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class OrdersResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {


        $data= [
            'id' => $this->id,
            'payment_method' => PaymentMethod::find($this->payment_method)->name[app()->getLocale()],
            'status'=> getOrderType($this->status),
            'status_id'=> $this->status,
            'order_date'=> Carbon::parse($this->created_at)->isoFormat('MMMM Do YYYY, h:mm a'),
            'created_at'=> $this->created_at,
            'delivered'=>$this->status == "done" ? 1 : 0,
            'has_rated'=> ProductRate::whereOrderId($this->id )->count() > 0 ,
            'whatsapp_numbner'=>settings()->whatsapp,
            'all_total'=> $this->all_total ,
            'user'=>[
               'id'=> $this->id,
               'name'=> $this->name,

            ]



        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
