<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {


        $data= [
            'id'  => $this->id,
            'discount'  => $this->discount,
            'after_discount'  => $this->after_discount,
            'image_path'=>'/uploads/products/',
            'image'  => $this->images()->first()->image,
            'height'  => $this->images()->first()->height,
            'width'  => $this->images()->first()->width,
            'title'  => $this->title[app()->getLocale()],
            'description'  => $this->description[app()->getLocale()],
            'description_string'  => trim(strip_tags($this->description[app()->getLocale()])),
        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
