<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Resources\Json\JsonResource;

class RateResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {

        $data= [
            'id' => $this->id,
            'user'  => [
                'id'=>$this->user_id,
                'name'=>$this->user->name,
                'height' => $this->user->height,
                'width' => $this->user->width,
                'image_path'=>'/uploads/users/',
                'image'=> $this->when($this->user->image != null,'secret-value') ,
            ],
            'comment'  => $this->comment,
            'created_at'  => $this->created_at->format('Y-m-d'),
        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
