<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class ReplyContactUs extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data         = $data;
        $this->siteName     = "Nosq";
        $this->siteEmail    = settings()->email;
        $this->sitePhone    = settings()->phone;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from(settings()->email,"info@nosq.app")
            ->view('emails.contact_us_reply')
            ->subject($this->data['mailSubject'])
            ->with([
                'headingTitle'  => $this->data['headingTitle'],
                'mailSubject'   => $this->data['mailSubject'],
                'mailMessage'   => $this->data['message'],
                'userMessage'   => $this->data['userMessage'],
                'siteName'      => $this->siteName,
                'siteEmail'     => $this->siteEmail,
                'sitePhone'     => $this->sitePhone,
            ]);
    }
}
