<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;
    protected $fillable=[
        'parent_id',
        'name',
        'image',
        'height',
        'width'
    ];
    protected $casts=[
        'name'=>'json'
    ];

    public function products()
    {
        return $this->hasMany(Product::class,'category_id');
    }
    public function category()
    {
        return $this->belongsTo(Category::class,'parent_id');
    }
    public function categories()
    {
        return $this->hasMany(Category::class,'parent_id');
    }
}
