<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable=[
        'title',
        'user_id',
        'category_id',
        'sub_category_id',
        'discount',
        'price',
        'after_discount',
        'description',
        'range',
        'special',
        'sold',
        'status',
        'active',
        'to_user',
        'type',
    ];
    protected $casts=[
        'title'=>'json',
        'description'=>'json',
    ];
    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }
    public function category()
    {
        return $this->belongsTo(Category::class,'category_id');
    }
    public function images()
    {
        return $this->hasMany(ProductImage::class,'product_id');
    }
}
