<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;
    protected $fillable=[
        'updated_by',
        'email',
        'phone',
        'about',
        'terms',
        'outside_price',
        'sms_url',
        'sms_username',
        'sms_password',
        'sms_sender',
        'snapchat',
        'instagram',
        'contact_with_admin',
        'whatsapp',
        'minimum_pull',
    ];

    protected $casts=[
        'contact_with_admin'=>'json'
    ];

    public function setAboutAttribute($value)
    {
        $this->attributes['about'] = serialize($value);
    }
    public function setTermsAttribute($value)
    {
        $this->attributes['terms'] = serialize($value);
    }



    public function updatedBy()
    {
        return $this->belongsTo(Admin::class);
    }
}
