<?php

namespace App\Providers;

use App\Models\Admin;
use App\Models\Bank;
use App\Models\Category;
use App\Models\Contact;
use App\Models\Coupon;
use App\Models\Order;
use App\Models\PaymentMethod;
use App\Models\Permission;
use App\Models\Post;
use App\Models\Product;
use App\Models\Question;
use App\Models\Region;
use App\Models\Role;
use App\Models\Setting;
use App\Models\Slider;
use App\Models\User;
use App\Models\UserWallet;
use App\Policies\AdminPolicy;
use App\Policies\BankPolicy;
use App\Policies\CategoryPolicy;
use App\Policies\CityPolicy;
use App\Policies\ContactPolicy;
use App\Policies\CouponPolicy;
use App\Policies\OrderPolicy;
use App\Policies\OrderTransferPolicy;
use App\Policies\PaymentMethodPolicy;
use App\Policies\PermissionPolicy;
use App\Policies\PostPolicy;
use App\Policies\ProductPolicy;
use App\Policies\ProductRatePolicy;
use App\Policies\QuestionPolicy;
use App\Policies\RolePolicy;
use App\Policies\SettingPolicy;
use App\Policies\SliderPolicy;
use App\Policies\UserPolicy;

use App\Policies\UserWalletPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        'App\Model' => 'App\Policies\ModelPolicy',
        Role::class             => RolePolicy::class,
        Admin::class            => AdminPolicy::class,
        Permission::class       => PermissionPolicy::class,
        Setting::class       => SettingPolicy::class,
        Region::class       => CityPolicy::class,
        Slider::class       => SliderPolicy::class,
        Coupon::class       => CouponPolicy::class,
        User::class       => UserPolicy::class,
        Category::class       => CategoryPolicy::class,
        Contact::class       => ContactPolicy::class,
//        Subscription::class       => SubscriptionPolicy::class,
        Product::class       => ProductPolicy::class,
        Order::class       => OrderPolicy::class,
//        ProductRate::class       => ProductRatePolicy::class,
        PaymentMethod::class       => PaymentMethodPolicy::class,
        Question::class       => QuestionPolicy::class,
        Bank::class       => BankPolicy::class,
        Post::class       => PostPolicy::class,
        OrderPolicy::class       => OrderTransferPolicy::class,
        UserWallet::class       => UserWalletPolicy::class,


    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        //
    }
}
