@extends('admin.layouts.master')

@section('title')
    @lang('messages.View_admin_details')
@endsection



@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.admins.index') }}">@lang('messages.administrators')</a></li>
                        <li class="breadcrumb-item active">@lang('messages.View_admin_details')</li>
                    </ol>
                </div>
                <h4 class="page-title">@lang('messages.View_admin_details')</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-4 col-xl-4">
            <div class="card-box text-center">
                <img src="{{ $admin->image ? URL::asset('uploads/admins/'.$admin->image) : URL::asset('admin/images/admin.png') }}" class="rounded mr-1" height="60"  alt="{{ $admin->name }}" class="rounded-circle avatar-lg img-thumbnail"
                     >

                <h4 class="mb-2"> {{ $admin->name }} </h4>


                @can('edit_permissions', \App\Permission::class)

                    <button type="button" class="btn btn-success btn-xs waves-effect mb-2 waves-light" onclick='window.location.href="{{ route('admin.admins.permissions', $admin->id) }}"'>@lang('messages.View_powers')</button>
                @endcan


                <div class="text-left mt-3">
                    <h4 class="font-13 text-uppercase">@lang('messages.Powers')</h4>
                    <h1 class=" mb-3 badge badge-success">
                        {{ $admin->roles[0]->name }}
                    </h1>
                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.name') :</strong> <span class="ml-2">{{$admin->name}}</span></p>

                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.phone') :</strong><span class="ml-2">{{ $admin->phone }}</span></p>

                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.email') :</strong> <span class="ml-2 ">{{ $admin->email }}</span></p>
                    <p class=" mb-2 font-13"><strong>@lang('messages.Activation') :</strong>  <span class="ml-2 badge badge-pill {{ $admin->status ? "badge-secondary" : "badge-light-secondary" }}">
                        {{ $admin->status ? trans('messages.Activate') : trans('messages.Deactivate') }}
                    </span></p>
                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.Date_added') :</strong> <span class="ml-2 badge badge-info ">{{ $admin->created_at->format('Y-m-d g:i A') }}</span></p>
                </div>


            </div> <!-- end card-box -->



        </div> <!-- end col-->


    </div>

@endsection
@section('scripts')
    <script>
        $('body').addClass('page-container-bg-solid');
    </script>
@endsection
